/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class UnicastResourceShowExecutor
implements DatabaseAdminQueryExecutor {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final SelectStatement sqlStatement;
    private final String sql;
    private MergedResult mergedResult;
    private JDBCDatabaseCommunicationEngine databaseCommunicationEngine;
    private ResponseHeader responseHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        String databaseName;
        String originDatabase = connectionSession.getDatabaseName();
        String string = databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        if (!ProxyContext.getInstance().getDatabase(databaseName).hasDataSource()) {
            throw new RuleNotExistedException();
        }
        try {
            connectionSession.setCurrentDatabase(databaseName);
            SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (SQLStatement)this.sqlStatement, (String)connectionSession.getDefaultDatabaseName());
            this.databaseCommunicationEngine = (JDBCDatabaseCommunicationEngine)this.databaseCommunicationEngineFactory.newTextProtocolInstance(sqlStatementContext, this.sql, connectionSession.getBackendConnection());
            this.responseHeader = this.databaseCommunicationEngine.execute();
            this.mergedResult = new TransparentMergedResult(this.createQueryResult());
        }
        finally {
            connectionSession.setCurrentDatabase(originDatabase);
            this.databaseCommunicationEngine.close();
        }
    }

    private String getFirstDatabaseName() {
        Collection<String> databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<String> result = databaseNames.stream().filter(each -> ProxyContext.getInstance().getDatabase((String)each).hasDataSource()).findFirst();
        if (!result.isPresent()) {
            throw new RuleNotExistedException();
        }
        return result.get();
    }

    @Override
    public QueryResultMetaData getQueryResultMetaData() {
        List columns = ((QueryResponseHeader)this.responseHeader).getQueryHeaders().stream().map(QueryHeader::getColumnLabel).map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 100, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    private QueryResult createQueryResult() throws SQLException {
        LinkedList<MemoryQueryResultDataRow> rows = new LinkedList<MemoryQueryResultDataRow>();
        while (this.databaseCommunicationEngine.next()) {
            Collection<Object> data = this.databaseCommunicationEngine.getQueryResponseRow().getData();
            rows.add(new MemoryQueryResultDataRow(new ArrayList<Object>(data)));
        }
        return new RawMemoryQueryResult(this.getQueryResultMetaData(), rows);
    }

    @Generated
    public DatabaseCommunicationEngineFactory getDatabaseCommunicationEngineFactory() {
        return this.databaseCommunicationEngineFactory;
    }

    @Generated
    public SelectStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public JDBCDatabaseCommunicationEngine getDatabaseCommunicationEngine() {
        return this.databaseCommunicationEngine;
    }

    @Generated
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    @Generated
    public UnicastResourceShowExecutor(SelectStatement sqlStatement, String sql) {
        this.sqlStatement = sqlStatement;
        this.sql = sql;
    }
}

