/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.util.RegularUtil;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class ShowTablesExecutor
implements DatabaseAdminQueryExecutor {
    private static final String TABLE_TYPE = "BASE TABLE";
    private final MySQLShowTablesStatement showTablesStatement;
    private final DatabaseType databaseType;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public void execute(ConnectionSession connectionSession) {
        this.queryResultMetaData = this.createQueryResultMetaData(connectionSession.getDatabaseName());
        this.mergedResult = new TransparentMergedResult(this.getQueryResult(connectionSession.getDatabaseName()));
    }

    private QueryResult getQueryResult(String databaseName) {
        if (!this.databaseType.getSystemSchemas().contains(databaseName) && !ProxyContext.getInstance().getDatabase(databaseName).isComplete()) {
            return new RawMemoryQueryResult(this.queryResultMetaData, Collections.emptyList());
        }
        List rows = this.getAllTableNames(databaseName).stream().map(each -> {
            LinkedList<String> rowValues = new LinkedList<String>();
            rowValues.add((String)each);
            rowValues.add(TABLE_TYPE);
            return new MemoryQueryResultDataRow(rowValues);
        }).collect(Collectors.toList());
        return new RawMemoryQueryResult(this.queryResultMetaData, rows);
    }

    private Collection<String> getAllTableNames(String databaseName) {
        Collection result = ((ShardingSphereSchema)ProxyContext.getInstance().getDatabase(databaseName).getSchemas().get(databaseName)).getTables().values().stream().map(ShardingSphereTable::getName).collect(Collectors.toList());
        if (this.showTablesStatement.getFilter().isPresent()) {
            Optional<String> pattern = ((ShowFilterSegment)this.showTablesStatement.getFilter().get()).getLike().map(optional -> SQLUtil.convertLikePatternToRegex((String)optional.getPattern()));
            return pattern.isPresent() ? (Collection)result.stream().filter(each -> RegularUtil.matchesCaseInsensitive((String)pattern.get(), each)).collect(Collectors.toList()) : result;
        }
        return result;
    }

    private QueryResultMetaData createQueryResultMetaData(String databaseName) {
        LinkedList<RawQueryResultColumnMetaData> columnNames = new LinkedList<RawQueryResultColumnMetaData>();
        String tableColumnName = String.format("Tables_in_%s", databaseName);
        columnNames.add(new RawQueryResultColumnMetaData("", tableColumnName, tableColumnName, 12, "VARCHAR", 255, 0));
        columnNames.add(new RawQueryResultColumnMetaData("", "Table_type", "Table_type", 12, "VARCHAR", 20, 0));
        return new RawQueryResultMetaData(columnNames);
    }

    @Generated
    public ShowTablesExecutor(MySQLShowTablesStatement showTablesStatement, DatabaseType databaseType) {
        this.showTablesStatement = showTablesStatement;
        this.databaseType = databaseType;
    }

    @Generated
    public MySQLShowTablesStatement getShowTablesStatement() {
        return this.showTablesStatement;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

