/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Locale;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerInfo;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseSetCharsetExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;

public final class MySQLSetCharsetExecutor
implements DatabaseSetCharsetExecutor {
    private final SetStatement setStatement;
    private String currentValue;

    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        VariableAssignSegment segment = (VariableAssignSegment)this.setStatement.getVariableAssigns().iterator().next();
        String value = this.formatValue(segment.getAssignValue().trim());
        Charset charset = this.parseCharset(value);
        this.currentValue = value;
        connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)charset);
    }

    private String formatValue(String value) {
        return value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value.trim();
    }

    private Charset parseCharset(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "default": {
                return MySQLServerInfo.DEFAULT_CHARSET.getCharset();
            }
            case "utf8mb4": {
                return StandardCharsets.UTF_8;
            }
        }
        return Charset.forName(value);
    }

    @Override
    public String getCurrentCharset() {
        return this.currentValue;
    }

    @Generated
    public MySQLSetCharsetExecutor(SetStatement setStatement) {
        this.setStatement = setStatement;
    }
}

