/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.AbstractDatabaseMetadataExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.information.SelectInformationSchemataExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class MySQLInformationSchemaExecutorFactory {
    public static final String SCHEMATA_TABLE = "SCHEMATA";
    public static final Collection<String> DEFAULT_EXECUTOR_TABLES = new HashSet<String>(Arrays.asList("ENGINES", "FILES", "VIEWS", "TRIGGERS", "PARTITIONS"));

    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatement sqlStatement, String sql) {
        String tableName = ((SimpleTableSegment)sqlStatement.getFrom()).getTableName().getIdentifier().getValue();
        if (SCHEMATA_TABLE.equalsIgnoreCase(tableName)) {
            return Optional.of(new SelectInformationSchemataExecutor(sqlStatement, sql));
        }
        if (DEFAULT_EXECUTOR_TABLES.contains(tableName.toUpperCase())) {
            return Optional.of(new AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor(sql));
        }
        return Optional.empty();
    }
}

