/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.mysql;

import java.util.Iterator;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.MySQLInformationSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.MySQLSetCharsetExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.NoResourceSetExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.NoResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowConnectionIdExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCreateDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCurrentDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowCurrentUserExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowDatabasesExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowFunctionStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowProcedureStatusExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowProcessListExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowTablesExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowTransactionExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.ShowVersionExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.UnicastResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.mysql.executor.UseDatabaseExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class MySQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String PERFORMANCE_SCHEMA = "performance_schema";

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLShowFunctionStatusStatement) {
            return Optional.of(new ShowFunctionStatusExecutor((MySQLShowFunctionStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcedureStatusStatement) {
            return Optional.of(new ShowProcedureStatusExecutor((MySQLShowProcedureStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowTablesStatement) {
            return Optional.of(new ShowTablesExecutor((MySQLShowTablesStatement)sqlStatement, sqlStatementContext.getDatabaseType()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof UseStatement) {
            return Optional.of(new UseDatabaseExecutor((UseStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowDatabasesStatement) {
            return Optional.of(new ShowDatabasesExecutor((MySQLShowDatabasesStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcessListStatement) {
            return Optional.of(new ShowProcessListExecutor());
        }
        if (sqlStatement instanceof MySQLShowCreateDatabaseStatement) {
            return Optional.of(new ShowCreateDatabaseExecutor((MySQLShowCreateDatabaseStatement)sqlStatement));
        }
        if (sqlStatement instanceof SetStatement) {
            if (!this.hasDatabases() || !this.hasResources()) {
                return Optional.of(new NoResourceSetExecutor((SetStatement)sqlStatement));
            }
            if (this.isSetClientEncoding((SetStatement)sqlStatement)) {
                return Optional.of(new MySQLSetCharsetExecutor((SetStatement)sqlStatement));
            }
        }
        if (sqlStatement instanceof SelectStatement) {
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "connection_id()")) {
                return Optional.of(new ShowConnectionIdExecutor());
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "version()")) {
                return Optional.of(new ShowVersionExecutor());
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "current_user()") || this.isShowSpecialFunction((SelectStatement)sqlStatement, "current_user")) {
                return Optional.of(new ShowCurrentUserExecutor());
            }
            if (!(this.hasDatabases() && this.hasResources() || !this.isShowSpecialFunction((SelectStatement)sqlStatement, "@@session.transaction_read_only"))) {
                return Optional.of(new ShowTransactionExecutor("@@session.transaction_read_only"));
            }
            if (!(this.hasDatabases() && this.hasResources() || !this.isShowSpecialFunction((SelectStatement)sqlStatement, "@@session.transaction_isolation"))) {
                return Optional.of(new ShowTransactionExecutor("@@session.transaction_isolation"));
            }
            if (this.isShowSpecialFunction((SelectStatement)sqlStatement, "DATABASE()")) {
                return Optional.of(new ShowCurrentDatabaseExecutor());
            }
            if (this.isQueryInformationSchema((SelectStatement)sqlStatement)) {
                return MySQLInformationSchemaExecutorFactory.newInstance((SelectStatement)sqlStatement, sql);
            }
            if (this.isQueryPerformanceSchema((SelectStatement)sqlStatement)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.mockExecutor(databaseName, (SelectStatement)sqlStatement, sql));
        }
        return Optional.empty();
    }

    private boolean isShowSpecialFunction(SelectStatement sqlStatement, String functionName) {
        ProjectionSegment firstProjection = (ProjectionSegment)sqlStatement.getProjections().getProjections().iterator().next();
        return firstProjection instanceof ExpressionProjectionSegment && functionName.equalsIgnoreCase(((ExpressionProjectionSegment)firstProjection).getText());
    }

    private boolean isQueryInformationSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, INFORMATION_SCHEMA);
    }

    private boolean isQueryPerformanceSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, PERFORMANCE_SCHEMA);
    }

    private boolean isQuerySpecialSchema(SelectStatement sqlStatement, String specialSchemaName) {
        TableSegment tableSegment = sqlStatement.getFrom();
        if (!(tableSegment instanceof SimpleTableSegment)) {
            return false;
        }
        return ((SimpleTableSegment)tableSegment).getOwner().isPresent() && specialSchemaName.equalsIgnoreCase(((OwnerSegment)((SimpleTableSegment)tableSegment).getOwner().get()).getIdentifier().getValue());
    }

    private DatabaseAdminExecutor mockExecutor(String databaseName, SelectStatement sqlStatement, String sql) {
        boolean isNotUseSchema;
        boolean bl = isNotUseSchema = !Optional.ofNullable(databaseName).isPresent() && sqlStatement.getFrom() == null;
        if (!this.hasDatabases() || !this.hasResources()) {
            return new NoResourceShowExecutor(sqlStatement);
        }
        String driverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        if (isNotUseSchema) {
            return "ExperimentalVertx".equals(driverType) ? null : new UnicastResourceShowExecutor(sqlStatement, sql);
        }
        return null;
    }

    private boolean hasDatabases() {
        return !ProxyContext.getInstance().getAllDatabaseNames().isEmpty();
    }

    private boolean hasResources() {
        return ProxyContext.getInstance().getAllDatabaseNames().stream().anyMatch(each -> ProxyContext.getInstance().getDatabase((String)each).hasDataSource());
    }

    private boolean isSetClientEncoding(SetStatement setStatement) {
        Iterator iterator = setStatement.getVariableAssigns().iterator();
        return iterator.hasNext() && "charset".equalsIgnoreCase(((VariableAssignSegment)iterator.next()).getVariable().getVariable());
    }

    public String getType() {
        return "MySQL";
    }
}

