/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.transparent.TransparentMergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.ResourceNotExistedException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.admin.FunctionWithException;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseMetadataExecutor
implements DatabaseAdminQueryExecutor {
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;
    private final LinkedList<Map<String, Object>> rows = new LinkedList();

    @Override
    public final void execute(ConnectionSession connectionSession) throws SQLException {
        List<String> databaseNames = this.getDatabaseNames(connectionSession);
        for (String databaseName : databaseNames) {
            this.initDatabaseData(databaseName);
            this.getSourceData(databaseName, resultSet -> this.handleResultSet(databaseName, (ResultSet)resultSet));
        }
        this.createPreProcessing();
        this.queryResultMetaData = this.createQueryResultMetaData();
        this.mergedResult = this.createMergedResult();
    }

    private void handleResultSet(String databaseName, ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            LinkedHashMap<String, Object> rowMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, String> aliasMap = new LinkedHashMap<String, String>();
            ResultSetMetaData metaData = resultSet.getMetaData();
            for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                aliasMap.put(metaData.getColumnName(i), metaData.getColumnLabel(i));
                rowMap.put(metaData.getColumnLabel(i), resultSet.getString(i));
            }
            this.rowPostProcessing(databaseName, rowMap, aliasMap);
            if (rowMap.isEmpty()) continue;
            this.rows.addFirst(rowMap);
        }
    }

    protected abstract void initDatabaseData(String var1);

    protected abstract List<String> getDatabaseNames(ConnectionSession var1);

    protected abstract void createPreProcessing();

    protected abstract void getSourceData(String var1, FunctionWithException<ResultSet, SQLException> var2) throws SQLException;

    protected abstract void rowPostProcessing(String var1, Map<String, Object> var2, Map<String, String> var3);

    private MergedResult createMergedResult() {
        List resultDataRows = this.rows.stream().map(each -> new MemoryQueryResultDataRow(new LinkedList(each.values()))).collect(Collectors.toList());
        return new TransparentMergedResult((QueryResult)new RawMemoryQueryResult(this.queryResultMetaData, resultDataRows));
    }

    private RawQueryResultMetaData createQueryResultMetaData() {
        List columns = this.rows.stream().flatMap(each -> each.keySet().stream()).collect(Collectors.toCollection(LinkedHashSet::new)).stream().map(each -> new RawQueryResultColumnMetaData("", each, each, 12, "VARCHAR", 20, 0)).collect(Collectors.toList());
        return new RawQueryResultMetaData(columns);
    }

    protected static Boolean hasDatasource(String databaseName) {
        return ProxyContext.getInstance().getDatabase(databaseName).hasDataSource();
    }

    protected static boolean hasAuthority(String databaseName, Grantee grantee) {
        return SQLCheckEngine.check((String)databaseName, AbstractDatabaseMetadataExecutor.getRules(databaseName), (Grantee)grantee);
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    public LinkedList<Map<String, Object>> getRows() {
        return this.rows;
    }

    public static class DefaultDatabaseMetadataExecutor
    extends AbstractDatabaseMetadataExecutor {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseMetadataExecutor.class);
        private final String sql;

        public DefaultDatabaseMetadataExecutor(String sql) {
            this.sql = sql;
        }

        @Override
        protected void initDatabaseData(String databaseName) {
        }

        @Override
        protected List<String> getDatabaseNames(ConnectionSession connectionSession) {
            String database = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> DefaultDatabaseMetadataExecutor.hasAuthority(each, connectionSession.getGrantee())).filter(AbstractDatabaseMetadataExecutor::hasDatasource).findFirst().orElseThrow(ResourceNotExistedException::new);
            return Collections.singletonList(database);
        }

        @Override
        protected void getSourceData(String databaseName, FunctionWithException<ResultSet, SQLException> callback) throws SQLException {
            ShardingSphereResource resource = ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getResource();
            Optional dataSourceEntry = resource.getDataSources().entrySet().stream().findFirst();
            log.info("Actual SQL: {} ::: {}", ((Map.Entry)dataSourceEntry.orElseThrow(ResourceNotExistedException::new)).getKey(), (Object)this.sql);
            try (Connection conn = ((DataSource)((Map.Entry)dataSourceEntry.get()).getValue()).getConnection();
                 PreparedStatement ps = conn.prepareStatement(this.sql);
                 ResultSet resultSet = ps.executeQuery();){
                callback.apply(resultSet);
            }
        }

        @Override
        protected void rowPostProcessing(String databaseName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        }

        @Override
        protected void createPreProcessing() {
        }

        @Generated
        public String getSql() {
            return this.sql;
        }
    }
}

