/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;

public final class DatabaseAdminQueryBackendHandler
implements TextProtocolBackendHandler {
    private final ConnectionSession connectionSession;
    private final DatabaseAdminQueryExecutor executor;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.executor.execute(this.connectionSession);
        this.queryResultMetaData = this.executor.getQueryResultMetaData();
        this.mergedResult = this.executor.getMergedResult();
        return new QueryResponseHeader(this.createResponseHeader());
    }

    private List<QueryHeader> createResponseHeader() throws SQLException {
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(this.queryResultMetaData.getColumnCount());
        ShardingSphereDatabase database = null == this.connectionSession.getDatabaseName() ? null : ProxyContext.getInstance().getDatabase(this.connectionSession.getDatabaseName());
        DatabaseType databaseType = null == database ? this.connectionSession.getDatabaseType() : database.getProtocolType();
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(databaseType);
        LazyInitializer<DataNodeContainedRule> dataNodeContainedRule = this.getDataNodeContainedRuleLazyInitializer(database);
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(queryHeaderBuilderEngine.build(this.queryResultMetaData, database, columnIndex, dataNodeContainedRule));
        }
        return result;
    }

    private LazyInitializer<DataNodeContainedRule> getDataNodeContainedRuleLazyInitializer(final ShardingSphereDatabase database) {
        return new LazyInitializer<DataNodeContainedRule>(){

            protected DataNodeContainedRule initialize() {
                return null == database ? null : (DataNodeContainedRule)database.getRuleMetaData().findSingleRule(DataNodeContainedRule.class).orElse(null);
            }
        };
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(this.mergedResult.getValue(columnIndex, Object.class));
        }
        return result;
    }

    @Generated
    public DatabaseAdminQueryBackendHandler(ConnectionSession connectionSession, DatabaseAdminQueryExecutor executor) {
        this.connectionSession = connectionSession;
        this.executor = executor;
    }
}

