/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.admin;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminQueryBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminUpdateBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminExecutorCreatorFactory;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.text.admin.executor.DatabaseSetCharsetExecutor;
import org.apache.shardingsphere.proxy.backend.text.encoding.DatabaseSetCharsetBackendHandler;

public final class DatabaseAdminBackendHandlerFactory {
    public static Optional<TextProtocolBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession) {
        Optional<DatabaseAdminExecutorCreator> creator = DatabaseAdminExecutorCreatorFactory.findInstance(databaseType);
        if (!creator.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = creator.get().create(sqlStatementContext);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createTextProtocolBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    public static Optional<TextProtocolBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession, String sql) {
        Optional<DatabaseAdminExecutorCreator> executorFactory = DatabaseAdminExecutorCreatorFactory.findInstance(databaseType);
        if (!executorFactory.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = executorFactory.get().create(sqlStatementContext, sql, connectionSession.getDatabaseName());
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createTextProtocolBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    private static TextProtocolBackendHandler createTextProtocolBackendHandler(SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession, DatabaseAdminExecutor executor) {
        if (executor instanceof DatabaseAdminQueryExecutor) {
            return new DatabaseAdminQueryBackendHandler(connectionSession, (DatabaseAdminQueryExecutor)executor);
        }
        if (executor instanceof DatabaseSetCharsetExecutor) {
            return new DatabaseSetCharsetBackendHandler(connectionSession, (DatabaseSetCharsetExecutor)executor);
        }
        return new DatabaseAdminUpdateBackendHandler(connectionSession, sqlStatementContext.getSqlStatement(), executor);
    }

    @Generated
    private DatabaseAdminBackendHandlerFactory() {
    }
}

