/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.QueryableRALStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementDatabaseHolder;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.admin.DatabaseAdminBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.data.DatabaseBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.database.DatabaseOperateBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.distsql.DistSQLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.text.extra.ExtraTextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.skip.SkipBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionBackendHandlerFactory;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.FlushStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.transaction.utils.AutoCommitUtils;

public final class TextProtocolBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(DatabaseType databaseType, String sql, Supplier<Optional<SQLStatement>> sqlStatementSupplier, ConnectionSession connectionSession) throws SQLException {
        Optional<ExtraTextProtocolBackendHandler> extraHandler;
        String trimSQL = SQLUtil.trimComment((String)sql);
        if (Strings.isNullOrEmpty((String)trimSQL)) {
            return new SkipBackendHandler((SQLStatement)new EmptyStatement());
        }
        SQLStatement sqlStatement = sqlStatementSupplier.get().orElseGet(() -> {
            Optional sqlParserRule = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().findSingleRule(SQLParserRule.class);
            Preconditions.checkState((boolean)sqlParserRule.isPresent());
            return ((SQLParserRule)sqlParserRule.get()).getSQLParserEngine(TextProtocolBackendHandlerFactory.getProtocolType(databaseType, connectionSession).getType()).parse(sql, false);
        });
        databaseType.handleRollbackOnly(connectionSession.getTransactionStatus().isRollbackOnly(), sqlStatement);
        TextProtocolBackendHandlerFactory.checkUnsupportedSQLStatement(sqlStatement);
        if (sqlStatement instanceof DistSQLStatement) {
            if (connectionSession.getTransactionStatus().isInTransaction() && !(sqlStatement instanceof RQLStatement) && !(sqlStatement instanceof QueryableRALStatement)) {
                throw new UnsupportedOperationException("Non-query dist sql is not supported within a transaction");
            }
            return DistSQLBackendHandlerFactory.newInstance(databaseType, (DistSQLStatement)sqlStatement, connectionSession);
        }
        TextProtocolBackendHandlerFactory.handleAutoCommit(sqlStatement, connectionSession);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)connectionSession.getDefaultDatabaseName());
        Optional<TextProtocolBackendHandler> backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession, sql);
        if (backendHandler.isPresent()) {
            return backendHandler.get();
        }
        if (sqlStatementContext instanceof TableAvailable) {
            ((TableAvailable)sqlStatementContext).getTablesContext().getDatabaseName().ifPresent(SQLStatementDatabaseHolder::set);
        }
        if ((extraHandler = TextProtocolBackendHandlerFactory.findExtraTextProtocolBackendHandler(sqlStatement)).isPresent()) {
            return extraHandler.get();
        }
        Optional<TextProtocolBackendHandler> databaseOperateHandler = TextProtocolBackendHandlerFactory.findDatabaseOperateBackendHandler(sqlStatement, connectionSession);
        if (databaseOperateHandler.isPresent()) {
            return databaseOperateHandler.get();
        }
        String databaseName = sqlStatementContext.getTablesContext().getDatabaseName().isPresent() ? (String)sqlStatementContext.getTablesContext().getDatabaseName().get() : connectionSession.getDatabaseName();
        SQLCheckEngine.check((SQLStatement)sqlStatement, Collections.emptyList(), TextProtocolBackendHandlerFactory.getRules(databaseName), (String)databaseName, (Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (Grantee)connectionSession.getGrantee());
        if (sqlStatement instanceof TCLStatement) {
            return TransactionBackendHandlerFactory.newInstance((SQLStatementContext<? extends TCLStatement>)sqlStatementContext, sql, connectionSession);
        }
        backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession);
        return backendHandler.orElseGet(() -> DatabaseBackendHandlerFactory.newInstance(sqlStatementContext, sql, connectionSession));
    }

    private static DatabaseType getProtocolType(DatabaseType defaultDatabaseType, ConnectionSession connectionSession) {
        String databaseName = connectionSession.getDatabaseName();
        return Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().databaseExists(databaseName) ? defaultDatabaseType : ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getProtocolType();
    }

    private static void handleAutoCommit(SQLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        if (AutoCommitUtils.needOpenTransaction((SQLStatement)sqlStatement)) {
            connectionSession.getBackendConnection().handleAutoCommit();
        }
    }

    private static Optional<ExtraTextProtocolBackendHandler> findExtraTextProtocolBackendHandler(SQLStatement sqlStatement) {
        for (ExtraTextProtocolBackendHandler each : ShardingSphereServiceLoader.getServiceInstances(ExtraTextProtocolBackendHandler.class)) {
            if (!each.accept(sqlStatement)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static Optional<TextProtocolBackendHandler> findDatabaseOperateBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        if (sqlStatement instanceof CreateDatabaseStatement || sqlStatement instanceof DropDatabaseStatement) {
            return Optional.of(DatabaseOperateBackendHandlerFactory.newInstance(sqlStatement, connectionSession));
        }
        return Optional.empty();
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        MetaDataContexts contexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().databaseExists(databaseName)) {
            return contexts.getMetaData().getGlobalRuleMetaData().getRules();
        }
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(((ShardingSphereDatabase)contexts.getMetaData().getDatabases().get(databaseName)).getRuleMetaData().getRules());
        result.addAll(contexts.getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    private static void checkUnsupportedSQLStatement(SQLStatement sqlStatement) {
        if (sqlStatement instanceof DCLStatement || sqlStatement instanceof FlushStatement || sqlStatement instanceof MySQLShowCreateUserStatement) {
            throw new UnsupportedOperationException("Unsupported operation");
        }
    }

    @Generated
    private TextProtocolBackendHandlerFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(ExtraTextProtocolBackendHandler.class);
    }
}

