/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.proxy.backend.exception.UnknownDatabaseException;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.available.FromDatabaseAvailable;

public abstract class DatabaseRequiredBackendHandler<T extends SQLStatement>
implements TextProtocolBackendHandler {
    private final T sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public final ResponseHeader execute() throws SQLException {
        String databaseName = this.getDatabaseName(this.connectionSession, this.sqlStatement);
        this.checkDatabaseName(databaseName);
        return this.execute(databaseName, this.sqlStatement);
    }

    protected abstract ResponseHeader execute(String var1, T var2) throws SQLException;

    private String getDatabaseName(ConnectionSession connectionSession, T sqlStatement) {
        Optional schemaFromSQL = sqlStatement instanceof FromDatabaseAvailable ? ((FromDatabaseAvailable)sqlStatement).getDatabase() : Optional.empty();
        return schemaFromSQL.isPresent() ? ((DatabaseSegment)schemaFromSQL.get()).getIdentifier().getValue() : connectionSession.getDatabaseName();
    }

    private void checkDatabaseName(String databaseName) {
        if (null == databaseName) {
            throw new NoDatabaseSelectedException();
        }
        if (!ProxyContext.getInstance().databaseExists(databaseName)) {
            throw new UnknownDatabaseException(databaseName);
        }
    }

    @Generated
    public DatabaseRequiredBackendHandler(T sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }

    @Generated
    public T getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }
}

