/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session.transaction;

import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class TransactionStatus {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 200L;
    private static final int MAXIMUM_RETRY_COUNT = 5;
    private volatile boolean inTransaction;
    private volatile TransactionType transactionType;
    private volatile boolean manualXA;
    private volatile boolean rollbackOnly;

    public TransactionStatus(TransactionType initialTransactionType) {
        this.transactionType = initialTransactionType;
    }

    public TransactionType getTransactionType() {
        return this.manualXA ? TransactionType.MANUALXA : this.transactionType;
    }

    public boolean isInTransaction() {
        return this.inTransaction || this.manualXA;
    }

    public void setTransactionType(TransactionType transactionType) {
        if (this.inTransaction) {
            throw new ShardingSphereException("Failed to switch transaction type, please terminate current transaction.", new Object[0]);
        }
        this.transactionType = transactionType;
    }

    public boolean isInConnectionHeldTransaction() {
        return this.isInTransaction() && TransactionType.BASE != this.getTransactionType();
    }

    @Generated
    public boolean isManualXA() {
        return this.manualXA;
    }

    @Generated
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Generated
    public void setInTransaction(boolean inTransaction) {
        this.inTransaction = inTransaction;
    }

    @Generated
    public void setManualXA(boolean manualXA) {
        this.manualXA = manualXA;
    }

    @Generated
    public void setRollbackOnly(boolean rollbackOnly) {
        this.rollbackOnly = rollbackOnly;
    }
}

