/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.session;

import io.netty.util.AttributeMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementDatabaseHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.sql.parser.sql.common.constant.TransactionIsolationLevel;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ConnectionSession {
    private final DatabaseType databaseType;
    private volatile String databaseName;
    private volatile int connectionId;
    private volatile Grantee grantee;
    private final TransactionStatus transactionStatus;
    private final AttributeMap attributeMap;
    private final AtomicBoolean autoCommit = new AtomicBoolean(true);
    private AtomicBoolean readOnly = new AtomicBoolean(false);
    private TransactionIsolationLevel defaultIsolationLevel;
    private TransactionIsolationLevel isolationLevel;
    private final BackendConnection backendConnection;
    private final ExecutorStatementManager statementManager;
    private final Map<String, CursorStatementContext> cursorDefinitions = new ConcurrentHashMap<String, CursorStatementContext>();

    public ConnectionSession(DatabaseType databaseType, TransactionType initialTransactionType, AttributeMap attributeMap) {
        this.databaseType = databaseType;
        this.transactionStatus = new TransactionStatus(initialTransactionType);
        this.attributeMap = attributeMap;
        this.backendConnection = this.determineBackendConnection();
        this.statementManager = this.determineStatementManager();
    }

    private BackendConnection determineBackendConnection() {
        String proxyBackendDriverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        return "ExperimentalVertx".equals(proxyBackendDriverType) ? new VertxBackendConnection(this) : new JDBCBackendConnection(this);
    }

    private ExecutorStatementManager determineStatementManager() {
        String proxyBackendDriverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        return "ExperimentalVertx".equals(proxyBackendDriverType) ? new VertxBackendStatement() : new JDBCBackendStatement();
    }

    public void setCurrentDatabase(String databaseName) {
        if (null != databaseName && databaseName.equals(this.databaseName)) {
            return;
        }
        if (this.transactionStatus.isInTransaction()) {
            throw new ShardingSphereException("Failed to switch database, please terminate current transaction.", new Object[0]);
        }
        if (this.statementManager instanceof JDBCBackendStatement) {
            ((JDBCBackendStatement)this.statementManager).setDatabaseName(databaseName);
        }
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return null == SQLStatementDatabaseHolder.get() ? this.databaseName : SQLStatementDatabaseHolder.get();
    }

    public String getDefaultDatabaseName() {
        return this.databaseName;
    }

    public boolean isAutoCommit() {
        return this.autoCommit.get();
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit.set(autoCommit);
    }

    public boolean isReadOnly() {
        return this.readOnly.get();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly.set(readOnly);
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public int getConnectionId() {
        return this.connectionId;
    }

    @Generated
    public Grantee getGrantee() {
        return this.grantee;
    }

    @Generated
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @Generated
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Generated
    public TransactionIsolationLevel getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    @Generated
    public TransactionIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Generated
    public BackendConnection getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    public ExecutorStatementManager getStatementManager() {
        return this.statementManager;
    }

    @Generated
    public Map<String, CursorStatementContext> getCursorDefinitions() {
        return this.cursorDefinitions;
    }

    @Generated
    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }

    @Generated
    public void setGrantee(Grantee grantee) {
        this.grantee = grantee;
    }

    @Generated
    public void setDefaultIsolationLevel(TransactionIsolationLevel defaultIsolationLevel) {
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    @Generated
    public void setIsolationLevel(TransactionIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }
}

