/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.query.impl;

import java.sql.SQLException;
import java.util.Optional;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilder;

public final class MySQLQueryHeaderBuilder
implements QueryHeaderBuilder {
    @Override
    public QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, String columnName, String columnLabel, int columnIndex, LazyInitializer<DataNodeContainedRule> dataNodeContainedRule) throws SQLException {
        boolean primaryKey;
        String tableName;
        String schemaName = null == database ? "" : database.getName();
        String actualTableName = queryResultMetaData.getTableName(columnIndex);
        if (null != actualTableName && null != dataNodeContainedRule.get()) {
            tableName = ((DataNodeContainedRule)dataNodeContainedRule.get()).findLogicTableByActualTable(actualTableName).orElse("");
            ShardingSphereTable table = ((ShardingSphereSchema)database.getSchemas().get(schemaName)).get(tableName);
            primaryKey = null != table && Optional.ofNullable((ShardingSphereColumn)table.getColumns().get(columnName.toLowerCase())).map(ShardingSphereColumn::isPrimaryKey).orElse(false) != false;
        } else {
            tableName = actualTableName;
            primaryKey = false;
        }
        int columnType = queryResultMetaData.getColumnType(columnIndex);
        String columnTypeName = queryResultMetaData.getColumnTypeName(columnIndex);
        int columnLength = queryResultMetaData.getColumnLength(columnIndex);
        int decimals = queryResultMetaData.getDecimals(columnIndex);
        boolean signed = queryResultMetaData.isSigned(columnIndex);
        boolean notNull = queryResultMetaData.isNotNull(columnIndex);
        boolean autoIncrement = queryResultMetaData.isAutoIncrement(columnIndex);
        return new QueryHeader(schemaName, tableName, columnLabel, columnName, columnType, columnTypeName, columnLength, decimals, signed, primaryKey, notNull, autoIncrement);
    }

    public String getType() {
        return "MySQL";
    }

    public boolean isDefault() {
        return true;
    }
}

