/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.context;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.state.StateContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.datasource.JDBCBackendDataSource;
import org.apache.shardingsphere.proxy.backend.exception.NoDatabaseSelectedException;

public final class ProxyContext {
    private static final ProxyContext INSTANCE = new ProxyContext();
    private final JDBCBackendDataSource backendDataSource = new JDBCBackendDataSource();
    private ContextManager contextManager;

    public static void init(ContextManager contextManager) {
        ProxyContext.INSTANCE.contextManager = contextManager;
    }

    public static ProxyContext getInstance() {
        return INSTANCE;
    }

    public boolean databaseExists(String name) {
        return this.contextManager.getMetaDataContexts().getMetaData().getDatabases().containsKey(name);
    }

    public ShardingSphereDatabase getDatabase(String name) {
        if (Strings.isNullOrEmpty((String)name) || !this.contextManager.getMetaDataContexts().getMetaData().getDatabases().containsKey(name)) {
            throw new NoDatabaseSelectedException();
        }
        return (ShardingSphereDatabase)this.contextManager.getMetaDataContexts().getMetaData().getDatabases().get(name);
    }

    public Collection<String> getAllDatabaseNames() {
        return this.contextManager.getMetaDataContexts().getMetaData().getDatabases().keySet();
    }

    public Optional<StateContext> getStateContext() {
        return null == this.contextManager.getInstanceContext() ? Optional.empty() : Optional.ofNullable(this.contextManager.getInstanceContext().getInstance().getState());
    }

    public Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        if (!Strings.isNullOrEmpty((String)databaseName) && this.databaseExists(databaseName)) {
            result.addAll(((ShardingSphereDatabase)this.contextManager.getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().getRules());
        }
        result.addAll(this.contextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    private ProxyContext() {
    }

    @Generated
    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }
}

