/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.config.yaml.swapper;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceGeneratedDatabaseConfiguration;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.ProxyGlobalConfiguration;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;

public final class YamlProxyConfigurationSwapper {
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();
    private final YamlRuleConfigurationSwapperEngine ruleConfigSwapperEngine = new YamlRuleConfigurationSwapperEngine();

    public ProxyConfiguration swap(YamlProxyConfiguration yamlConfig) {
        Map<String, DatabaseConfiguration> databaseConfigs = this.swapDatabaseConfigurations(yamlConfig);
        ProxyGlobalConfiguration globalConfig = new ProxyGlobalConfiguration(this.ruleConfigSwapperEngine.swapToRuleConfigurations(yamlConfig.getServerConfiguration().getRules()), yamlConfig.getServerConfiguration().getProps(), yamlConfig.getServerConfiguration().getLabels());
        return new ProxyConfiguration(databaseConfigs, globalConfig);
    }

    private Map<String, DatabaseConfiguration> swapDatabaseConfigurations(YamlProxyConfiguration yamlConfig) {
        LinkedHashMap<String, DatabaseConfiguration> result = new LinkedHashMap<String, DatabaseConfiguration>(yamlConfig.getDatabaseConfigurations().size(), 1.0f);
        for (Map.Entry<String, YamlProxyDatabaseConfiguration> entry : yamlConfig.getDatabaseConfigurations().entrySet()) {
            Map<String, DataSourceConfiguration> databaseDataSourceConfigs = this.swapDataSourceConfigurations(entry.getValue().getDataSources(), entry.getValue().getDatabaseName());
            Collection databaseRuleConfigs = this.ruleConfigSwapperEngine.swapToRuleConfigurations(entry.getValue().getRules());
            result.put(entry.getKey(), (DatabaseConfiguration)new DataSourceGeneratedDatabaseConfiguration(databaseDataSourceConfigs, databaseRuleConfigs));
        }
        return result;
    }

    private Map<String, DataSourceConfiguration> swapDataSourceConfigurations(Map<String, YamlProxyDataSourceConfiguration> yamlConfigs, String databaseName) {
        LinkedHashMap<String, DataSourceConfiguration> result = new LinkedHashMap<String, DataSourceConfiguration>(yamlConfigs.size(), 1.0f);
        for (Map.Entry<String, YamlProxyDataSourceConfiguration> entry : yamlConfigs.entrySet()) {
            result.put(entry.getKey(), this.dataSourceConfigSwapper.swap(entry.getValue()));
        }
        return result;
    }
}

