/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.vertx.transaction;

import io.vertx.core.Future;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.TransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;

public final class VertxLocalTransactionManager
implements TransactionManager<Future<Void>> {
    private final VertxBackendConnection connection;

    @Override
    public Future<Void> begin() {
        if (this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            return Future.succeededFuture();
        }
        this.connection.getConnectionSession().getTransactionStatus().setInTransaction(true);
        this.connection.getConnectionPostProcessors().add(target -> target.compose(connection -> connection.query("begin").execute().compose(unused -> target)));
        return Future.succeededFuture();
    }

    @Override
    public Future<Void> commit() {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            return Future.succeededFuture();
        }
        this.connection.getConnectionSession().getTransactionStatus().setInTransaction(false);
        this.connection.getConnectionPostProcessors().clear();
        return this.connection.executeInAllCachedConnections("commit");
    }

    @Override
    public Future<Void> rollback() {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            return Future.succeededFuture();
        }
        this.connection.getConnectionSession().getTransactionStatus().setInTransaction(false);
        this.connection.getConnectionPostProcessors().clear();
        return this.connection.executeInAllCachedConnections("rollback");
    }

    @Override
    public Future<Void> setSavepoint(String savepointName) {
        return Future.failedFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public Future<Void> rollbackTo(String savepointName) {
        return Future.failedFuture((Throwable)new UnsupportedOperationException());
    }

    @Override
    public Future<Void> releaseSavepoint(String savepointName) {
        return Future.failedFuture((Throwable)new UnsupportedOperationException());
    }

    @Generated
    public VertxLocalTransactionManager(VertxBackendConnection connection) {
        this.connection = connection;
    }
}

