/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.vertx.executor;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class ProxyReactiveExecutor {
    private final VertxExecutor vertxExecutor;

    public Future<List<ExecuteResult>> execute(LogicSQL logicSQL, ExecutionGroupContext<VertxExecutionUnit> executionGroupContext) throws SQLException {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)metaDataContexts.getMetaData().getProps());
        List futures = this.vertxExecutor.execute(executionGroupContext, new VertxExecutorCallback());
        return CompositeFuture.all(new ArrayList(futures)).compose(compositeFuture -> {
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            return Future.succeededFuture((Object)compositeFuture.list());
        }).eventually(unused -> {
            ExecuteProcessEngine.clean();
            return Future.succeededFuture();
        });
    }

    @Generated
    public ProxyReactiveExecutor(VertxExecutor vertxExecutor) {
        this.vertxExecutor = vertxExecutor;
    }
}

