/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.vertx;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.ReactiveProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;

public final class VertxDatabaseCommunicationEngine
extends DatabaseCommunicationEngine<Future<ResponseHeader>> {
    private final ReactiveProxySQLExecutor reactiveProxySQLExecutor;

    public VertxDatabaseCommunicationEngine(ShardingSphereDatabase database, LogicSQL logicSQL, VertxBackendConnection vertxBackendConnection) {
        super("Vert.x", database, logicSQL, vertxBackendConnection);
        this.reactiveProxySQLExecutor = new ReactiveProxySQLExecutor(vertxBackendConnection);
    }

    @Override
    public Future<ResponseHeader> execute() {
        try {
            ExecutionContext executionContext = this.getKernelProcessor().generateExecutionContext(this.getLogicSQL(), this.getDatabase(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps());
            if (executionContext.getRouteContext().isFederated()) {
                return Future.failedFuture((Throwable)new UnsupportedOperationException("Executing federated query by Vert.x is not supported yet."));
            }
            if (executionContext.getExecutionUnits().isEmpty()) {
                return Future.succeededFuture((Object)new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement()));
            }
            this.reactiveProxySQLExecutor.checkExecutePrerequisites(executionContext);
            this.checkLockedDatabase(executionContext);
            return this.reactiveProxySQLExecutor.execute(executionContext).compose(result -> {
                try {
                    this.refreshMetaData(executionContext);
                    ExecuteResult executeResultSample = (ExecuteResult)result.iterator().next();
                    return Future.succeededFuture((Object)(executeResultSample instanceof QueryResult ? this.processExecuteQuery(executionContext, (List<QueryResult>)result, (QueryResult)executeResultSample) : this.processExecuteUpdate(executionContext, (Collection<UpdateResult>)result)));
                }
                catch (SQLException ex) {
                    return Future.failedFuture((Throwable)ex);
                }
            });
        }
        catch (Exception ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }
}

