/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.vertx;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import io.netty.util.NettyRuntime;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.cpu.CpuCoreSensor;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.BackendDataSource;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VertxBackendDataSource
implements BackendDataSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VertxBackendDataSource.class);
    private static volatile VertxBackendDataSource instance;
    private final Map<String, Map<String, Pool>> schemaVertxPools = new ConcurrentHashMap<String, Map<String, Pool>>();
    private final Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true).setEventLoopPoolSize(this.determineEventLoopPoolSize()));

    private VertxBackendDataSource() {
    }

    private int determineEventLoopPoolSize() {
        return Math.min(CpuCoreSensor.availableProcessors(), NettyRuntime.availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VertxBackendDataSource getInstance() {
        if (null != instance) return instance;
        Class<VertxBackendDataSource> clazz = VertxBackendDataSource.class;
        synchronized (VertxBackendDataSource.class) {
            if (null != instance) return instance;
            VertxBackendDataSource.logWarningBanner();
            instance = new VertxBackendDataSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void logWarningBanner() {
        log.warn("\n\u2588\u2588     \u2588\u2588  \u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588\u2588    \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588    \u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588  \n\u2588\u2588     \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588\u2588\u2588   \u2588\u2588 \u2588\u2588 \u2588\u2588\u2588\u2588   \u2588\u2588 \u2588\u2588       \n\u2588\u2588  \u2588  \u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588\u2588  \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588   \u2588\u2588\u2588 \n\u2588\u2588 \u2588\u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588 \u2588\u2588  \u2588\u2588 \u2588\u2588 \u2588\u2588    \u2588\u2588 \n \u2588\u2588\u2588 \u2588\u2588\u2588  \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588 \u2588\u2588   \u2588\u2588\u2588\u2588 \u2588\u2588 \u2588\u2588   \u2588\u2588\u2588\u2588  \u2588\u2588\u2588\u2588\u2588\u2588  \n\n       Experimental reactive backend enabled!\n");
    }

    public List<Future<SqlConnection>> getConnections(String databaseName, String dataSourceName, int connectionSize) {
        Pool pool = this.getPool(databaseName, dataSourceName);
        ArrayList<Future<SqlConnection>> result = new ArrayList<Future<SqlConnection>>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            result.add((Future<SqlConnection>)pool.getConnection());
        }
        return result;
    }

    public Pool getPool(String databaseName, String dataSourceName) {
        Pool result;
        Map vertxPools = this.schemaVertxPools.get(databaseName);
        if (null == vertxPools) {
            vertxPools = this.schemaVertxPools.computeIfAbsent(databaseName, unused -> new ConcurrentHashMap());
        }
        if (null == (result = vertxPools.get(dataSourceName))) {
            result = vertxPools.computeIfAbsent(dataSourceName, unused -> this.createPoolFromSchemaDataSource(databaseName, dataSourceName));
        }
        return result;
    }

    private Pool createPoolFromSchemaDataSource(String databaseName, String dataSourceName) {
        DataSource dataSource = (DataSource)((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getResource().getDataSources().get(dataSourceName);
        Preconditions.checkNotNull((Object)dataSource, (String)"Can not get connection from datasource %s.", (Object)dataSourceName);
        HikariDataSource value = (HikariDataSource)dataSource;
        URI uri = URI.create(value.getJdbcUrl().replace("jdbc:", ""));
        switch (uri.getScheme()) {
            case "mysql": {
                return this.createMySQLPool(value, uri);
            }
            case "postgresql": {
                throw new UnsupportedOperationException("For now");
            }
            case "opengauss": {
                throw new UnsupportedOperationException("For now");
            }
        }
        throw new UnsupportedOperationException("Database " + uri.getScheme() + " unsupported");
    }

    private MySQLPool createMySQLPool(HikariDataSource value, URI uri) {
        MySQLConnectOptions options = new MySQLConnectOptions().setHost(uri.getHost()).setPort(uri.getPort()).setDatabase(uri.getPath().replace("/", "")).setUser(value.getUsername()).setCachePreparedStatements(true).setPreparedStatementCacheMaxSize(16384);
        if (!Strings.isNullOrEmpty((String)value.getPassword())) {
            options = options.setPassword(value.getPassword());
        }
        PoolOptions poolOptions = new PoolOptions().setMaxSize(value.getMaximumPoolSize()).setIdleTimeout((int)value.getIdleTimeout()).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setConnectionTimeout((int)value.getConnectionTimeout()).setConnectionTimeoutUnit(TimeUnit.MILLISECONDS);
        return MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)options, (PoolOptions)poolOptions);
    }

    @Generated
    public Vertx getVertx() {
        return this.vertx;
    }
}

