/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.proxy.backend.communication.TransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.LocalTransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.sharding.merge.ddl.fetch.FetchOrderByValueQueuesHolder;
import org.apache.shardingsphere.transaction.ConnectionSavepointManager;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.TransactionHolder;
import org.apache.shardingsphere.transaction.core.TransactionType;
import org.apache.shardingsphere.transaction.spi.ShardingSphereTransactionManager;

public final class JDBCBackendTransactionManager
implements TransactionManager<Void> {
    private final JDBCBackendConnection connection;
    private final TransactionType transactionType;
    private final LocalTransactionManager localTransactionManager;
    private final ShardingSphereTransactionManager shardingSphereTransactionManager;

    public JDBCBackendTransactionManager(JDBCBackendConnection backendConnection) {
        this.connection = backendConnection;
        this.transactionType = this.connection.getConnectionSession().getTransactionStatus().getTransactionType();
        this.localTransactionManager = new LocalTransactionManager(backendConnection);
        ShardingSphereTransactionManagerEngine engine = (ShardingSphereTransactionManagerEngine)ProxyContext.getInstance().getContextManager().getTransactionContexts().getEngines().get(this.connection.getConnectionSession().getDatabaseName());
        this.shardingSphereTransactionManager = null == engine ? null : engine.getTransactionManager(this.transactionType);
    }

    @Override
    public Void begin() throws SQLException {
        if (!this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            this.connection.getConnectionSession().getTransactionStatus().setInTransaction(true);
            TransactionHolder.setInTransaction();
            this.connection.closeDatabaseCommunicationEngines(true);
            this.connection.closeConnections(false);
        }
        if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
            this.localTransactionManager.begin();
        } else {
            this.shardingSphereTransactionManager.begin();
        }
        return null;
    }

    @Override
    public Void commit() throws SQLException {
        if (this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
                    this.localTransactionManager.commit();
                } else {
                    this.shardingSphereTransactionManager.commit(this.connection.getConnectionSession().getTransactionStatus().isRollbackOnly());
                }
            }
            finally {
                this.connection.getConnectionSession().getTransactionStatus().setInTransaction(false);
                this.connection.getConnectionSession().getTransactionStatus().setRollbackOnly(false);
                TransactionHolder.clear();
                FetchOrderByValueQueuesHolder.remove();
            }
        }
        return null;
    }

    @Override
    public Void rollback() throws SQLException {
        if (this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            try {
                if (TransactionType.LOCAL == this.transactionType || null == this.shardingSphereTransactionManager) {
                    this.localTransactionManager.rollback();
                } else {
                    this.shardingSphereTransactionManager.rollback();
                }
            }
            finally {
                this.connection.getConnectionSession().getTransactionStatus().setInTransaction(false);
                this.connection.getConnectionSession().getTransactionStatus().setRollbackOnly(false);
                TransactionHolder.clear();
                FetchOrderByValueQueuesHolder.remove();
            }
        }
        return null;
    }

    @Override
    public Void setSavepoint(String savepointName) throws SQLException {
        for (Connection each : this.connection.getCachedConnections().values()) {
            ConnectionSavepointManager.getInstance().setSavepoint(each, savepointName);
        }
        this.connection.getConnectionPostProcessors().add(target -> {
            try {
                ConnectionSavepointManager.getInstance().setSavepoint(target, savepointName);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
        return null;
    }

    @Override
    public Void rollbackTo(String savepointName) throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().rollbackToSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (result.isEmpty() && this.connection.getConnectionSession().getTransactionStatus().isRollbackOnly()) {
            this.connection.getConnectionSession().getTransactionStatus().setRollbackOnly(false);
        }
        return this.throwSQLExceptionIfNecessary(result);
    }

    @Override
    public Void releaseSavepoint(String savepointName) throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                ConnectionSavepointManager.getInstance().releaseSavepoint(each, savepointName);
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return this.throwSQLExceptionIfNecessary(result);
    }

    private Void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return null;
        }
        SQLException ex = new SQLException("");
        exceptions.forEach(ex::setNextException);
        throw ex;
    }
}

