/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.parameter.TypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.SQLStatementDatabaseHolder;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.StatementMemoryStrictlyFetchSizeSetter;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.StatementMemoryStrictlyFetchSizeSetterFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class JDBCBackendStatement
implements ExecutorJDBCStatementManager {
    private String databaseName;

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        Statement result = connection.createStatement();
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    public Statement createStorageResource(ExecutionUnit executionUnit, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        String sql = executionUnit.getSqlUnit().getSql();
        List parameters = executionUnit.getSqlUnit().getParameters();
        PreparedStatement result = option.isReturnGeneratedKeys() ? connection.prepareStatement(executionUnit.getSqlUnit().getSql(), 1) : connection.prepareStatement(sql);
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            if (parameter instanceof TypeUnspecifiedSQLParameter) {
                result.setObject(i + 1, parameter, 1111);
                continue;
            }
            result.setObject(i + 1, parameter);
        }
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    private void setFetchSize(Statement statement) throws SQLException {
        DatabaseType databaseType = ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(null == this.databaseName ? SQLStatementDatabaseHolder.get() : this.databaseName)).getResource().getDatabaseType();
        Optional<StatementMemoryStrictlyFetchSizeSetter> fetchSizeSetter = StatementMemoryStrictlyFetchSizeSetterFactory.findInstance(databaseType.getType());
        if (fetchSizeSetter.isPresent()) {
            fetchSizeSetter.get().setFetchSize(statement);
        }
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

