/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.executor;

import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class ProxyJDBCExecutor {
    private final String type;
    private final ConnectionSession connectionSession;
    private final JDBCDatabaseCommunicationEngine databaseCommunicationEngine;
    private final JDBCExecutor jdbcExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExecuteResult> execute(LogicSQL logicSQL, ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        try {
            MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
            DatabaseType databaseType = ((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.connectionSession.getDatabaseName())).getResource().getDatabaseType();
            ExecuteProcessEngine.initialize((LogicSQL)logicSQL, executionGroupContext, (ConfigurationProperties)metaDataContexts.getMetaData().getProps());
            SQLStatementContext context = logicSQL.getSqlStatementContext();
            List result = this.jdbcExecutor.execute(executionGroupContext, (JDBCExecutorCallback)ProxyJDBCExecutorCallbackFactory.newInstance(this.type, databaseType, context.getSqlStatement(), this.databaseCommunicationEngine, isReturnGeneratedKeys, isExceptionThrown, true), (JDBCExecutorCallback)ProxyJDBCExecutorCallbackFactory.newInstance(this.type, databaseType, context.getSqlStatement(), this.databaseCommunicationEngine, isReturnGeneratedKeys, isExceptionThrown, false));
            ExecuteProcessEngine.finish((String)executionGroupContext.getExecutionID());
            List list = result;
            return list;
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    @Generated
    public ProxyJDBCExecutor(String type, ConnectionSession connectionSession, JDBCDatabaseCommunicationEngine databaseCommunicationEngine, JDBCExecutor jdbcExecutor) {
        this.type = type;
        this.connectionSession = connectionSession;
        this.databaseCommunicationEngine = databaseCommunicationEngine;
        this.jdbcExecutor = jdbcExecutor;
    }

    @Generated
    public JDBCExecutor getJdbcExecutor() {
        return this.jdbcExecutor;
    }
}

