/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCConnectionManager;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionPostProcessor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ResourceLock;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.JDBCBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class JDBCBackendConnection
implements BackendConnection<Void>,
ExecutorJDBCConnectionManager {
    private final ConnectionSession connectionSession;
    private volatile FederationExecutor federationExecutor;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final Collection<JDBCDatabaseCommunicationEngine> databaseCommunicationEngines = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<JDBCDatabaseCommunicationEngine> inUseDatabaseCommunicationEngines = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ConnectionPostProcessor<Connection>> connectionPostProcessors = new LinkedList<ConnectionPostProcessor<Connection>>();
    private final ResourceLock resourceLock = new ResourceLock();
    private volatile int connectionReferenceCount;

    public JDBCBackendConnection(ConnectionSession connectionSession) {
        this.connectionSession = connectionSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createNewConnections(dataSourceName, connectionSize - connections.size(), connectionMode);
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = this.createNewConnections(dataSourceName, connectionSize, connectionMode);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    private List<Connection> createNewConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        Preconditions.checkNotNull((Object)this.connectionSession.getDatabaseName(), (Object)"Current schema is null.");
        List<Connection> result = ProxyContext.getInstance().getBackendDataSource().getConnections(this.connectionSession.getDatabaseName(), dataSourceName, connectionSize, connectionMode);
        for (Connection each : result) {
            this.replayTransactionOption(each);
        }
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            for (Connection each : result) {
                this.replayMethodsInvocation(each);
            }
        }
        return result;
    }

    private void replayMethodsInvocation(Connection target) {
        for (ConnectionPostProcessor<Connection> each : this.connectionPostProcessors) {
            each.process(target);
        }
    }

    private void replayTransactionOption(Connection connection) throws SQLException {
        if (null == connection) {
            return;
        }
        if (this.connectionSession.isReadOnly()) {
            connection.setReadOnly(true);
        }
        if (null != this.connectionSession.getIsolationLevel()) {
            connection.setTransactionIsolation(TransactionUtil.getTransactionIsolationLevel(this.connectionSession.getIsolationLevel()));
        }
    }

    public boolean isSerialExecute() {
        return this.connectionSession.getTransactionStatus().isInTransaction() && (TransactionType.LOCAL == this.connectionSession.getTransactionStatus().getTransactionType() || TransactionType.XA == this.connectionSession.getTransactionStatus().getTransactionType());
    }

    public int getConnectionSize() {
        return this.cachedConnections.values().size();
    }

    public void add(JDBCDatabaseCommunicationEngine databaseCommunicationEngine) {
        this.databaseCommunicationEngines.add(databaseCommunicationEngine);
    }

    public void markResourceInUse(JDBCDatabaseCommunicationEngine databaseCommunicationEngine) {
        this.inUseDatabaseCommunicationEngines.add(databaseCommunicationEngine);
    }

    public void unmarkResourceInUse(JDBCDatabaseCommunicationEngine databaseCommunicationEngine) {
        this.inUseDatabaseCommunicationEngines.remove(databaseCommunicationEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void prepareForTaskExecution() {
        JDBCBackendConnection jDBCBackendConnection = this;
        synchronized (jDBCBackendConnection) {
            ++this.connectionReferenceCount;
            return null;
        }
    }

    @Override
    public Void handleAutoCommit() throws SQLException {
        if (!this.connectionSession.isAutoCommit() && !this.connectionSession.getTransactionStatus().isInTransaction()) {
            JDBCBackendTransactionManager transactionManager = new JDBCBackendTransactionManager(this);
            transactionManager.begin();
        }
        return null;
    }

    @Override
    public Void closeExecutionResources() throws BackendConnectionException {
        JDBCBackendConnection jDBCBackendConnection = this;
        synchronized (jDBCBackendConnection) {
            if (this.connectionReferenceCount > 0 && this.connectionReferenceCount-- > 1) {
                return null;
            }
            LinkedList<Exception> result = new LinkedList<Exception>();
            result.addAll(this.closeDatabaseCommunicationEngines(false));
            result.addAll(this.closeFederationExecutor());
            if (!this.connectionSession.getTransactionStatus().isInConnectionHeldTransaction()) {
                result.addAll(this.closeDatabaseCommunicationEngines(true));
                result.addAll(this.closeConnections(false));
            }
            if (result.isEmpty()) {
                return null;
            }
            throw new BackendConnectionException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void closeAllResources() {
        JDBCBackendConnection jDBCBackendConnection = this;
        synchronized (jDBCBackendConnection) {
            this.closeDatabaseCommunicationEngines(true);
            this.closeConnections(true);
            this.closeFederationExecutor();
            return null;
        }
    }

    public Collection<SQLException> closeDatabaseCommunicationEngines(boolean includeInUse) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (JDBCDatabaseCommunicationEngine each : this.databaseCommunicationEngines) {
            if (!includeInUse && this.inUseDatabaseCommunicationEngines.contains(each)) continue;
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (includeInUse) {
            this.inUseDatabaseCommunicationEngines.clear();
        }
        this.databaseCommunicationEngines.retainAll(this.inUseDatabaseCommunicationEngines);
        return result;
    }

    public Collection<SQLException> closeConnections(boolean forceRollback) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                if (forceRollback && this.connectionSession.getTransactionStatus().isInTransaction()) {
                    each.rollback();
                }
                this.resetConnection(each);
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedConnections.clear();
        this.connectionPostProcessors.clear();
        return result;
    }

    private void resetConnection(Connection connection) throws SQLException {
        if (null == connection) {
            return;
        }
        if (this.connectionSession.isReadOnly()) {
            connection.setReadOnly(false);
        }
        if (null != this.connectionSession.getDefaultIsolationLevel()) {
            connection.setTransactionIsolation(TransactionUtil.getTransactionIsolationLevel(this.connectionSession.getIsolationLevel()));
        }
    }

    public Collection<SQLException> closeFederationExecutor() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        if (null != this.federationExecutor) {
            try {
                this.federationExecutor.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        return result;
    }

    @Override
    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @Generated
    public FederationExecutor getFederationExecutor() {
        return this.federationExecutor;
    }

    @Generated
    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    @Generated
    public Collection<JDBCDatabaseCommunicationEngine> getDatabaseCommunicationEngines() {
        return this.databaseCommunicationEngines;
    }

    @Generated
    public Collection<JDBCDatabaseCommunicationEngine> getInUseDatabaseCommunicationEngines() {
        return this.inUseDatabaseCommunicationEngines;
    }

    @Generated
    public Collection<ConnectionPostProcessor<Connection>> getConnectionPostProcessors() {
        return this.connectionPostProcessors;
    }

    @Generated
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Generated
    public int getConnectionReferenceCount() {
        return this.connectionReferenceCount;
    }

    @Generated
    public void setFederationExecutor(FederationExecutor federationExecutor) {
        this.federationExecutor = federationExecutor;
    }

    @Generated
    public void setConnectionReferenceCount(int connectionReferenceCount) {
        this.connectionReferenceCount = connectionReferenceCount;
    }
}

