/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutorFactory;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtil;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.ProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;

public final class JDBCDatabaseCommunicationEngine
extends DatabaseCommunicationEngine<ResponseHeader> {
    private final ProxySQLExecutor proxySQLExecutor;
    private final Collection<Statement> cachedStatements = new CopyOnWriteArrayList<Statement>();
    private final Collection<ResultSet> cachedResultSets = new CopyOnWriteArrayList<ResultSet>();
    private final FederationExecutor federationExecutor;
    private final JDBCBackendConnection backendConnection;

    public JDBCDatabaseCommunicationEngine(String driverType, ShardingSphereDatabase database, LogicSQL logicSQL, JDBCBackendConnection backendConnection) {
        super(driverType, database, logicSQL, backendConnection);
        this.proxySQLExecutor = new ProxySQLExecutor(driverType, backendConnection, this);
        this.backendConnection = backendConnection;
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String databaseName = backendConnection.getConnectionSession().getDatabaseName();
        DatabaseType databaseType = logicSQL.getSqlStatementContext().getDatabaseType();
        String schemaName = logicSQL.getSqlStatementContext().getTablesContext().getSchemaName().orElse(DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)databaseName));
        this.federationExecutor = FederationExecutorFactory.newInstance((String)databaseName, (String)schemaName, (OptimizerContext)metaDataContexts.getOptimizerContext(), (ConfigurationProperties)metaDataContexts.getMetaData().getProps(), (JDBCExecutor)new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), backendConnection.isSerialExecute()));
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    @Override
    public ResponseHeader execute() {
        LogicSQL logicSQL = this.getLogicSQL();
        ExecutionContext executionContext = this.getKernelProcessor().generateExecutionContext(logicSQL, this.getDatabase(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps());
        SQLStatementContext sqlStatementContext = logicSQL.getSqlStatementContext();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.backendConnection.getConnectionSession().getDatabaseName());
        if (executionContext.getRouteContext().isFederated() || sqlStatementContext instanceof SelectStatementContext && SystemSchemaUtil.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)sqlStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database)) {
            ResultSet resultSet = this.doExecuteFederation(logicSQL, metaDataContexts);
            return this.processExecuteFederation(resultSet, metaDataContexts);
        }
        if (executionContext.getExecutionUnits().isEmpty()) {
            return new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement());
        }
        this.proxySQLExecutor.checkExecutePrerequisites(executionContext);
        this.checkLockedDatabase(executionContext);
        List<ExecuteResult> result = this.proxySQLExecutor.execute(executionContext);
        this.refreshMetaData(executionContext);
        ExecuteResult executeResultSample = result.iterator().next();
        return executeResultSample instanceof QueryResult ? this.processExecuteQuery(executionContext, result, (QueryResult)executeResultSample) : this.processExecuteUpdate(executionContext, result);
    }

    private ResultSet doExecuteFederation(LogicSQL logicSQL, MetaDataContexts metaDataContexts) throws SQLException {
        boolean isReturnGeneratedKeys = logicSQL.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        DatabaseType databaseType = ((ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.backendConnection.getConnectionSession().getDatabaseName())).getResource().getDatabaseType();
        ProxyJDBCExecutorCallback callback = ProxyJDBCExecutorCallbackFactory.newInstance(this.getDriverType(), databaseType, logicSQL.getSqlStatementContext().getSqlStatement(), this, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown(), true);
        this.backendConnection.setFederationExecutor(this.federationExecutor);
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, metaDataContexts);
        FederationContext context = new FederationContext(false, logicSQL, metaDataContexts.getMetaData().getDatabases());
        return this.federationExecutor.executeQuery(prepareEngine, (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaData) {
        int maxConnectionsSizePerQuery = (Integer)metaData.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.backendConnection.getConnectionSession().getStatementManager();
        return new DriverExecutionPrepareEngine(this.getDriverType(), maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.backendConnection, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), ((ShardingSphereDatabase)metaData.getMetaData().getDatabases().get(this.backendConnection.getConnectionSession().getDatabaseName())).getRuleMetaData().getRules());
    }

    private ResponseHeader processExecuteFederation(ResultSet resultSet, MetaDataContexts metaDataContexts) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        this.setQueryHeaders(new ArrayList<QueryHeader>(columnCount));
        ShardingSphereDatabase database = (ShardingSphereDatabase)metaDataContexts.getMetaData().getDatabases().get(this.backendConnection.getConnectionSession().getDatabaseName());
        LazyInitializer<DataNodeContainedRule> dataNodeContainedRule = this.getDataNodeContainedRuleLazyInitializer(database);
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(null == database ? null : database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            this.getQueryHeaders().add(queryHeaderBuilderEngine.build((QueryResultMetaData)new JDBCQueryResultMetaData(resultSet.getMetaData()), database, columnIndex, dataNodeContainedRule));
        }
        this.setMergedResult((MergedResult)new IteratorStreamMergedResult(Collections.singletonList(new JDBCStreamQueryResult(resultSet))));
        return new QueryResponseHeader(this.getQueryHeaders());
    }

    public void close() throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        result.addAll(this.closeResultSets());
        result.addAll(this.closeStatements());
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        result.forEach(ex::setNextException);
        throw ex;
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedResultSets.clear();
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedStatements.clear();
        return result;
    }
}

