/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.SaneQueryResultEngineFactory;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawSQLExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.raw.RawExecutionPrepareEngine;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.RawExecutionRule;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.ProxyJDBCExecutor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.TableModifyInTransactionException;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCloseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussFetchStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussMoveStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ProxySQLExecutor {
    private final String type;
    private final JDBCBackendConnection backendConnection;
    private final ProxyJDBCExecutor jdbcExecutor;
    private final RawExecutor rawExecutor;

    public ProxySQLExecutor(String type, JDBCBackendConnection backendConnection, JDBCDatabaseCommunicationEngine databaseCommunicationEngine) {
        this.type = type;
        this.backendConnection = backendConnection;
        ExecutorEngine executorEngine = BackendExecutorContext.getInstance().getExecutorEngine();
        boolean isSerialExecute = backendConnection.isSerialExecute();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        this.jdbcExecutor = new ProxyJDBCExecutor(type, backendConnection.getConnectionSession(), databaseCommunicationEngine, new JDBCExecutor(executorEngine, isSerialExecute));
        this.rawExecutor = new RawExecutor(executorEngine, isSerialExecute, metaDataContexts.getMetaData().getProps());
    }

    public void checkExecutePrerequisites(ExecutionContext executionContext) {
        if (this.isExecuteDDLInXATransaction(executionContext.getSqlStatementContext().getSqlStatement()) || this.isExecuteDDLInPostgreSQLOpenGaussTransaction(executionContext.getSqlStatementContext().getSqlStatement())) {
            throw new TableModifyInTransactionException(executionContext.getSqlStatementContext());
        }
    }

    private boolean isExecuteDDLInXATransaction(SQLStatement sqlStatement) {
        TransactionStatus transactionStatus = this.backendConnection.getConnectionSession().getTransactionStatus();
        return TransactionType.XA == transactionStatus.getTransactionType() && sqlStatement instanceof DDLStatement && transactionStatus.isInTransaction();
    }

    private boolean isExecuteDDLInPostgreSQLOpenGaussTransaction(SQLStatement sqlStatement) {
        boolean isPostgreSQLOpenGaussStatement = sqlStatement instanceof PostgreSQLStatement || sqlStatement instanceof OpenGaussStatement;
        boolean isCursorStatement = sqlStatement instanceof OpenGaussCursorStatement || sqlStatement instanceof OpenGaussCloseStatement || sqlStatement instanceof OpenGaussMoveStatement || sqlStatement instanceof OpenGaussFetchStatement;
        return sqlStatement instanceof DDLStatement && !isCursorStatement && isPostgreSQLOpenGaussStatement && this.backendConnection.getConnectionSession().getTransactionStatus().isInTransaction();
    }

    public List<ExecuteResult> execute(ExecutionContext executionContext) throws SQLException {
        String databaseName = this.backendConnection.getConnectionSession().getDatabaseName();
        Collection rules = ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().get(databaseName)).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        boolean isReturnGeneratedKeys = executionContext.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        return this.execute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys);
    }

    private List<ExecuteResult> execute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys) throws SQLException {
        return this.hasRawExecutionRule(rules) ? this.rawExecute(executionContext, rules, maxConnectionsSizePerQuery) : this.useDriverToExecute(executionContext, rules, maxConnectionsSizePerQuery, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown());
    }

    private boolean hasRawExecutionRule(Collection<ShardingSphereRule> rules) {
        for (ShardingSphereRule each : rules) {
            if (!(each instanceof RawExecutionRule)) continue;
            return true;
        }
        return false;
    }

    private List<ExecuteResult> rawExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        RawExecutionPrepareEngine prepareEngine = new RawExecutionPrepareEngine(maxConnectionsSizePerQuery, rules);
        try {
            executionGroupContext = prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits());
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        executionGroupContext.setDatabaseName(this.backendConnection.getConnectionSession().getDatabaseName());
        executionGroupContext.setGrantee(this.backendConnection.getConnectionSession().getGrantee());
        return this.rawExecutor.execute(executionGroupContext, executionContext.getLogicSQL(), new RawSQLExecutorCallback());
    }

    private List<ExecuteResult> useDriverToExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery, boolean isReturnGeneratedKeys, boolean isExceptionThrown) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.backendConnection.getConnectionSession().getStatementManager();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(this.type, maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.backendConnection, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), rules);
        try {
            executionGroupContext = prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits());
        }
        catch (SQLException ex) {
            return this.getSaneExecuteResults(executionContext, ex);
        }
        executionGroupContext.setDatabaseName(this.backendConnection.getConnectionSession().getDatabaseName());
        executionGroupContext.setGrantee(this.backendConnection.getConnectionSession().getGrantee());
        return this.jdbcExecutor.execute(executionContext.getLogicSQL(), (ExecutionGroupContext<JDBCExecutionUnit>)executionGroupContext, isReturnGeneratedKeys, isExceptionThrown);
    }

    private List<ExecuteResult> getSaneExecuteResults(ExecutionContext executionContext, SQLException originalException) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName()).getResource().getDatabaseType();
        Optional executeResult = SaneQueryResultEngineFactory.getInstance((DatabaseType)databaseType).getSaneQueryResult(executionContext.getSqlStatementContext().getSqlStatement());
        if (executeResult.isPresent()) {
            return Collections.singletonList((ExecuteResult)executeResult.get());
        }
        throw originalException;
    }
}

