/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class DatabaseCommunicationEngineFactory {
    private static final DatabaseCommunicationEngineFactory INSTANCE = new DatabaseCommunicationEngineFactory();

    public static DatabaseCommunicationEngineFactory getInstance() {
        return INSTANCE;
    }

    public <T extends DatabaseCommunicationEngine> T newTextProtocolInstance(SQLStatementContext<?> sqlStatementContext, String sql, BackendConnection<?> backendConnection) {
        DatabaseCommunicationEngine result;
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(backendConnection.getConnectionSession().getDatabaseName());
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, sql, Collections.emptyList());
        if (backendConnection instanceof JDBCBackendConnection) {
            JDBCBackendConnection jdbcBackendConnection = (JDBCBackendConnection)backendConnection;
            result = new JDBCDatabaseCommunicationEngine("JDBC.STATEMENT", database, logicSQL, jdbcBackendConnection);
            jdbcBackendConnection.add((JDBCDatabaseCommunicationEngine)result);
        } else {
            VertxBackendConnection vertxBackendConnection = (VertxBackendConnection)backendConnection;
            result = new VertxDatabaseCommunicationEngine(database, logicSQL, vertxBackendConnection);
        }
        return (T)result;
    }

    public <T extends DatabaseCommunicationEngine> T newBinaryProtocolInstance(SQLStatementContext<?> sqlStatementContext, String sql, List<Object> parameters, BackendConnection<?> backendConnection) {
        DatabaseCommunicationEngine result;
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(backendConnection.getConnectionSession().getDatabaseName());
        LogicSQL logicSQL = new LogicSQL(sqlStatementContext, sql, parameters);
        if (backendConnection instanceof JDBCBackendConnection) {
            JDBCBackendConnection jdbcBackendConnection = (JDBCBackendConnection)backendConnection;
            result = new JDBCDatabaseCommunicationEngine("JDBC.PREPARED_STATEMENT", database, logicSQL, jdbcBackendConnection);
            jdbcBackendConnection.add((JDBCDatabaseCommunicationEngine)result);
        } else {
            VertxBackendConnection vertxBackendConnection = (VertxBackendConnection)backendConnection;
            result = new VertxDatabaseCommunicationEngine(database, logicSQL, vertxBackendConnection);
        }
        return (T)result;
    }

    @Generated
    private DatabaseCommunicationEngineFactory() {
    }
}

