/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.mode.manager.lock.ShardingSphereLockJudgeEngine;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.DatabaseLockedException;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.data.impl.BinaryQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.impl.TextQueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;

public abstract class DatabaseCommunicationEngine<T> {
    private final String driverType;
    private final ShardingSphereDatabase database;
    private final LogicSQL logicSQL;
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final MetaDataRefreshEngine metadataRefreshEngine;
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;
    private final BackendConnection<?> backendConnection;
    private final ShardingSphereLockJudgeEngine lockJudgeEngine;

    public DatabaseCommunicationEngine(String driverType, ShardingSphereDatabase database, LogicSQL logicSQL, BackendConnection<?> backendConnection) {
        this.driverType = driverType;
        this.database = database;
        this.logicSQL = logicSQL;
        this.backendConnection = backendConnection;
        String databaseName = backendConnection.getConnectionSession().getDatabaseName();
        this.metadataRefreshEngine = new MetaDataRefreshEngine(database, (FederationDatabaseMetaData)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getOptimizerContext().getFederationMetaData().getDatabases().get(databaseName), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getOptimizerContext().getPlannerContexts(), ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps());
        this.lockJudgeEngine = new ShardingSphereLockJudgeEngine(ProxyContext.getInstance().getContextManager().getInstanceContext().getLockContext());
    }

    public abstract T execute();

    protected void refreshMetaData(ExecutionContext executionContext) throws SQLException {
        Optional event = this.metadataRefreshEngine.refresh(executionContext.getSqlStatementContext(), () -> executionContext.getRouteContext().getRouteUnits().stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList()));
        if (ProxyContext.getInstance().getContextManager().getInstanceContext().isCluster() && event.isPresent()) {
            ShardingSphereEventBus.getInstance().post(event.get());
        }
    }

    protected QueryResponseHeader processExecuteQuery(ExecutionContext executionContext, List<QueryResult> queryResults, QueryResult queryResultSample) throws SQLException {
        this.queryHeaders = this.createQueryHeaders(executionContext, queryResultSample);
        this.mergedResult = this.mergeQuery(executionContext.getSqlStatementContext(), queryResults);
        return new QueryResponseHeader(this.queryHeaders);
    }

    protected List<QueryHeader> createQueryHeaders(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        int columnCount = this.getColumnCount(executionContext, queryResultSample);
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(columnCount);
        LazyInitializer<DataNodeContainedRule> dataNodeContainedRule = this.getDataNodeContainedRuleLazyInitializer(this.database);
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(this.database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            result.add(this.createQueryHeader(queryHeaderBuilderEngine, executionContext, queryResultSample, this.database, columnIndex, dataNodeContainedRule));
        }
        return result;
    }

    protected LazyInitializer<DataNodeContainedRule> getDataNodeContainedRuleLazyInitializer(final ShardingSphereDatabase database) {
        return new LazyInitializer<DataNodeContainedRule>(){

            protected DataNodeContainedRule initialize() {
                return null != database ? (DataNodeContainedRule)database.getRuleMetaData().findSingleRule(DataNodeContainedRule.class).orElse(null) : null;
            }
        };
    }

    protected QueryHeader createQueryHeader(QueryHeaderBuilderEngine queryHeaderBuilderEngine, ExecutionContext executionContext, QueryResult queryResultSample, ShardingSphereDatabase database, int columnIndex, LazyInitializer<DataNodeContainedRule> dataNodeContainedRule) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? queryHeaderBuilderEngine.build(((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext(), queryResultSample.getMetaData(), database, columnIndex, dataNodeContainedRule) : queryHeaderBuilderEngine.build(queryResultSample.getMetaData(), database, columnIndex, dataNodeContainedRule);
    }

    protected int getColumnCount(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? ((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext().getExpandProjections().size() : queryResultSample.getMetaData().getColumnCount();
    }

    protected boolean hasSelectExpandProjections(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections().isEmpty();
    }

    protected MergedResult mergeQuery(SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.database, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    protected UpdateResponseHeader processExecuteUpdate(ExecutionContext executionContext, Collection<UpdateResult> updateResults) {
        UpdateResponseHeader result = new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement(), updateResults);
        this.mergeUpdateCount(executionContext.getSqlStatementContext(), result);
        return result;
    }

    protected void mergeUpdateCount(SQLStatementContext<?> sqlStatementContext, UpdateResponseHeader response) {
        if (this.isNeedAccumulate(sqlStatementContext)) {
            response.mergeUpdateCount();
        }
    }

    protected boolean isNeedAccumulate(SQLStatementContext<?> sqlStatementContext) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.findDataNodeContainedRule();
        return dataNodeContainedRule.isPresent() && dataNodeContainedRule.get().isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames());
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule() {
        for (ShardingSphereRule each : this.database.getRuleMetaData().getRules()) {
            if (!(each instanceof DataNodeContainedRule)) continue;
            return Optional.of((DataNodeContainedRule)each);
        }
        return Optional.empty();
    }

    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    public QueryResponseRow getQueryResponseRow() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        boolean isBinary = this.isBinary();
        for (int columnIndex = 1; columnIndex <= this.queryHeaders.size(); ++columnIndex) {
            Object data = this.mergedResult.getValue(columnIndex, Object.class);
            if (isBinary) {
                cells.add(new BinaryQueryResponseCell(this.queryHeaders.get(columnIndex - 1).getColumnType(), data));
                continue;
            }
            cells.add(new TextQueryResponseCell(data));
        }
        return new QueryResponseRow(cells);
    }

    protected boolean isBinary() {
        return !"JDBC.STATEMENT".equals(this.driverType);
    }

    protected void checkLockedDatabase(ExecutionContext executionContext) {
        if (this.lockJudgeEngine.isLocked(this.backendConnection.getConnectionSession().getDatabaseName(), executionContext.getSqlStatementContext().getSqlStatement())) {
            throw new DatabaseLockedException(this.backendConnection.getConnectionSession().getDatabaseName());
        }
    }

    @Generated
    public DatabaseCommunicationEngine(String driverType, ShardingSphereDatabase database, LogicSQL logicSQL, MetaDataRefreshEngine metadataRefreshEngine, BackendConnection<?> backendConnection, ShardingSphereLockJudgeEngine lockJudgeEngine) {
        this.driverType = driverType;
        this.database = database;
        this.logicSQL = logicSQL;
        this.metadataRefreshEngine = metadataRefreshEngine;
        this.backendConnection = backendConnection;
        this.lockJudgeEngine = lockJudgeEngine;
    }

    @Generated
    protected String getDriverType() {
        return this.driverType;
    }

    @Generated
    protected ShardingSphereDatabase getDatabase() {
        return this.database;
    }

    @Generated
    protected LogicSQL getLogicSQL() {
        return this.logicSQL;
    }

    @Generated
    protected KernelProcessor getKernelProcessor() {
        return this.kernelProcessor;
    }

    @Generated
    protected MetaDataRefreshEngine getMetadataRefreshEngine() {
        return this.metadataRefreshEngine;
    }

    @Generated
    protected List<QueryHeader> getQueryHeaders() {
        return this.queryHeaders;
    }

    @Generated
    protected MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    protected BackendConnection<?> getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    protected ShardingSphereLockJudgeEngine getLockJudgeEngine() {
        return this.lockJudgeEngine;
    }

    @Generated
    protected void setQueryHeaders(List<QueryHeader> queryHeaders) {
        this.queryHeaders = queryHeaders;
    }

    @Generated
    protected void setMergedResult(MergedResult mergedResult) {
        this.mergedResult = mergedResult;
    }
}

