/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;

public final class CreateIndexStatementSchemaRefresher
implements MetaDataRefresher<CreateIndexStatement> {
    private static final String TYPE = CreateIndexStatement.class.getName();

    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String schemaName, CreateIndexStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String indexName;
        String string = indexName = null != sqlStatement.getIndex() ? sqlStatement.getIndex().getIndexName().getIdentifier().getValue() : IndexMetaDataUtil.getGeneratedLogicIndexName((Collection)sqlStatement.getColumns());
        if (Strings.isNullOrEmpty((String)indexName)) {
            return Optional.empty();
        }
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        ((ShardingSphereSchema)database.getSchemas().get(schemaName)).get(tableName).getIndexes().put(indexName, new ShardingSphereIndex(indexName));
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        event.getAlteredTables().add(((ShardingSphereSchema)database.getSchemas().get(schemaName)).get(tableName));
        return Optional.of(event);
    }

    public String getType() {
        return TYPE;
    }
}

