/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.planner.OptimizerPlannerContextFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AlterSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterSchemaStatementHandler;

public final class AlterSchemaStatementSchemaRefresher
implements MetaDataRefresher<AlterSchemaStatement> {
    private static final String TYPE = AlterSchemaStatement.class.getName();

    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, Collection<String> logicDataSourceNames, String schemaName, AlterSchemaStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        Optional renameSchemaName = AlterSchemaStatementHandler.getRenameSchema((AlterSchemaStatement)sqlStatement);
        if (!renameSchemaName.isPresent()) {
            return Optional.empty();
        }
        String actualSchemaName = sqlStatement.getSchemaName().getValue();
        this.putSchemaMetaData(database, federationDatabaseMetaData, optimizerPlanners, actualSchemaName, ((IdentifierValue)renameSchemaName.get()).getValue(), logicDataSourceNames);
        this.removeSchemaMetaData(database, federationDatabaseMetaData, optimizerPlanners, actualSchemaName);
        AlterSchemaEvent event = new AlterSchemaEvent(database.getName(), actualSchemaName, ((IdentifierValue)renameSchemaName.get()).getValue(), (ShardingSphereSchema)database.getSchemas().get(((IdentifierValue)renameSchemaName.get()).getValue()));
        return Optional.of(event);
    }

    private void removeSchemaMetaData(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, String schemaName) {
        ShardingSphereSchema schema = (ShardingSphereSchema)database.getSchemas().remove(schemaName);
        federationDatabaseMetaData.removeSchemaMetadata(schemaName);
        optimizerPlanners.put(federationDatabaseMetaData.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : schema.getAllTableNames()) {
            this.removeDataNode(rules, schemaName, each);
        }
    }

    private void removeDataNode(Collection<MutableDataNodeRule> rules, String schemaName, String tableName) {
        for (MutableDataNodeRule each : rules) {
            each.remove(schemaName, tableName);
        }
    }

    private void putSchemaMetaData(ShardingSphereDatabase database, FederationDatabaseMetaData federationDatabaseMetaData, Map<String, OptimizerPlannerContext> optimizerPlanners, String schemaName, String renameSchemaName, Collection<String> logicDataSourceNames) {
        ShardingSphereSchema schema = (ShardingSphereSchema)database.getSchemas().get(schemaName);
        database.getSchemas().put(renameSchemaName, schema);
        federationDatabaseMetaData.getSchemaMetadata(schemaName).ifPresent(optional -> federationDatabaseMetaData.putSchemaMetadata(renameSchemaName, optional));
        optimizerPlanners.put(federationDatabaseMetaData.getName(), OptimizerPlannerContextFactory.create((FederationDatabaseMetaData)federationDatabaseMetaData));
        Collection rules = database.getRuleMetaData().findRules(MutableDataNodeRule.class);
        for (String each : schema.getAllTableNames()) {
            if (this.containsInImmutableDataNodeContainedRule(each, database)) continue;
            this.putDataNode(rules, logicDataSourceNames.iterator().next(), renameSchemaName, each);
        }
    }

    private void putDataNode(Collection<MutableDataNodeRule> rules, String dataSourceName, String schemaName, String tableName) {
        for (MutableDataNodeRule each : rules) {
            each.put(dataSourceName, schemaName, tableName);
        }
    }

    private boolean containsInImmutableDataNodeContainedRule(String tableName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(tableName));
    }

    public String getType() {
        return TYPE;
    }
}

