/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shardingsphere.data.pipeline.spi.check.datasource;

import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.infra.util.spi.annotation.SingletonSPI;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPI;

import javax.sql.DataSource;
import java.util.Collection;

/**
 * Data source checker.
 */
@SingletonSPI
public interface DataSourceChecker extends TypedSPI {
    
    /**
     * Check data source connections.
     *
     * @param dataSources data sources
     */
    void checkConnection(Collection<? extends DataSource> dataSources);
    
    /**
     * Check user privileges.
     *
     * @param dataSources data sources
     */
    void checkPrivilege(Collection<? extends DataSource> dataSources);
    
    /**
     * Check data source variables.
     *
     * @param dataSources data sources
     */
    void checkVariable(Collection<? extends DataSource> dataSources);
    
    /**
     * Check table is empty.
     *
     * @param dataSources data sources
     * @param tableNameSchemaNameMapping mapping
     * @param logicTableNames logic table names
     */
    // TODO rename to common usage name
    // TODO Merge schemaName and tableNames
    void checkTargetTable(Collection<? extends DataSource> dataSources, TableNameSchemaNameMapping tableNameSchemaNameMapping, Collection<String> logicTableNames);
}
