/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.lock.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.retry.RetryExecutor;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;
import org.apache.shardingsphere.mode.repository.cluster.lock.impl.props.DefaultLockPropertyKey;
import org.apache.shardingsphere.mode.repository.cluster.lock.impl.props.DefaultLockTypedProperties;

public final class DefaultDistributedLock
implements DistributedLock {
    private final String lockKey;
    private final ClusterPersistRepository client;
    private final String instanceId;
    private final Map<Thread, LockData> threadData = new ConcurrentHashMap<Thread, LockData>();

    public DefaultDistributedLock(String lockKey, ClusterPersistRepository client, DefaultLockTypedProperties props) {
        this.lockKey = lockKey;
        this.client = client;
        this.instanceId = (String)props.getValue(DefaultLockPropertyKey.INSTANCE_ID);
    }

    @Override
    public boolean tryLock(long timeoutMillis) {
        Thread currentThread = Thread.currentThread();
        LockData lockData = this.threadData.get(currentThread);
        if (null != lockData) {
            lockData.increment();
            return true;
        }
        if (!new RetryExecutor(timeoutMillis, 100L).execute(this::persist, (Object)this.instanceId)) {
            return false;
        }
        this.threadData.put(currentThread, new LockData());
        return true;
    }

    private boolean persist(String value) {
        try {
            this.client.persistExclusiveEphemeral(this.lockKey, value);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Thread currentThread = Thread.currentThread();
        LockData lockData = this.threadData.get(currentThread);
        ShardingSpherePreconditions.checkNotNull((Object)lockData, () -> new IllegalMonitorStateException(String.format("You do not own the lock: %s.", this.lockKey)));
        int newLockCount = lockData.lockCount.decrementAndGet();
        if (newLockCount > 0) {
            return;
        }
        ShardingSpherePreconditions.checkState((newLockCount == 0 ? 1 : 0) != 0, () -> new IllegalMonitorStateException(String.format("Lock count has gone negative for lock: %s.", this.lockKey)));
        try {
            this.client.delete(this.lockKey);
        }
        finally {
            this.threadData.remove(currentThread);
        }
    }

    private static final class LockData {
        private final AtomicInteger lockCount = new AtomicInteger(1);

        private LockData() {
        }

        private void increment() {
            this.lockCount.incrementAndGet();
        }
    }
}

