/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api.advice;

import java.lang.reflect.Method;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.metrics.api.MetricsPool;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;

public final class TransactionAdvice
implements InstanceMethodAroundAdvice {
    public static final String COMMIT = "commit";
    public static final String ROLLBACK = "rollback";

    public void beforeMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        String methodName = method.getName();
        if (COMMIT.equals(methodName)) {
            MetricsPool.get("proxy_transaction_commit_total").ifPresent(MetricsWrapper::inc);
        } else if (ROLLBACK.equals(methodName)) {
            MetricsPool.get("proxy_transaction_rollback_total").ifPresent(MetricsWrapper::inc);
        }
    }

    static {
        MetricsPool.create("proxy_transaction_commit_total");
        MetricsPool.create("proxy_transaction_rollback_total");
    }
}

