/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api.advice;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.metrics.api.MetricsPool;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;

public final class SQLRouteEngineAdvice
implements InstanceMethodAroundAdvice {
    public void beforeMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        LogicSQL logicSQL = (LogicSQL)args[0];
        SQLStatement sqlStatement = logicSQL.getSqlStatementContext().getSqlStatement();
        if (sqlStatement instanceof InsertStatement) {
            MetricsPool.get("route_sql_insert_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof DeleteStatement) {
            MetricsPool.get("route_sql_delete_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof UpdateStatement) {
            MetricsPool.get("route_sql_update_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof SelectStatement) {
            MetricsPool.get("route_sql_select_total").ifPresent(MetricsWrapper::inc);
        }
    }

    public void afterMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        RouteContext routeContext = (RouteContext)result.getResult();
        if (null != routeContext) {
            Collection routeUnits = routeContext.getRouteUnits();
            routeUnits.forEach(each -> {
                RouteMapper dataSourceMapper = each.getDataSourceMapper();
                MetricsPool.get("route_datasource_total").ifPresent(optional -> optional.inc(dataSourceMapper.getActualName()));
                each.getTableMappers().forEach(table -> MetricsPool.get("route_table_total").ifPresent(optional -> optional.inc(table.getActualName())));
            });
        }
    }

    static {
        MetricsPool.create("route_sql_insert_total");
        MetricsPool.create("route_sql_delete_total");
        MetricsPool.create("route_sql_update_total");
        MetricsPool.create("route_sql_select_total");
        MetricsPool.create("route_datasource_total");
        MetricsPool.create("route_table_total");
    }
}

