/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api.advice;

import java.lang.reflect.Method;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.metrics.api.MetricsPool;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.UpdateStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;

public final class SQLParserEngineAdvice
implements InstanceMethodAroundAdvice {
    public void afterMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        SQLStatement sqlStatement = (SQLStatement)result.getResult();
        this.countSQL(sqlStatement);
        this.countDistSQL(sqlStatement);
    }

    private void countSQL(SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            MetricsPool.get("parse_sql_dml_insert_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof DeleteStatement) {
            MetricsPool.get("parse_sql_dml_delete_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof UpdateStatement) {
            MetricsPool.get("parse_sql_dml_update_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof SelectStatement) {
            MetricsPool.get("parse_sql_dml_select_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof DDLStatement) {
            MetricsPool.get("parse_sql_ddl_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof DCLStatement) {
            MetricsPool.get("parse_sql_dcl_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof DALStatement) {
            MetricsPool.get("parse_sql_dal_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof TCLStatement) {
            MetricsPool.get("parse_sql_tcl_total").ifPresent(MetricsWrapper::inc);
        }
    }

    private void countDistSQL(SQLStatement sqlStatement) {
        if (sqlStatement instanceof RQLStatement) {
            MetricsPool.get("parse_dist_sql_rql_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof RDLStatement) {
            MetricsPool.get("parse_dist_sql_rdl_total").ifPresent(MetricsWrapper::inc);
        } else if (sqlStatement instanceof RALStatement) {
            MetricsPool.get("parse_dist_sql_ral_total").ifPresent(MetricsWrapper::inc);
        }
    }

    static {
        MetricsPool.create("parse_sql_dml_insert_total");
        MetricsPool.create("parse_sql_dml_delete_total");
        MetricsPool.create("parse_sql_dml_update_total");
        MetricsPool.create("parse_sql_dml_select_total");
        MetricsPool.create("parse_sql_ddl_total");
        MetricsPool.create("parse_sql_dcl_total");
        MetricsPool.create("parse_sql_dal_total");
        MetricsPool.create("parse_sql_tcl_total");
        MetricsPool.create("parse_dist_sql_rql_total");
        MetricsPool.create("parse_dist_sql_rdl_total");
        MetricsPool.create("parse_dist_sql_ral_total");
    }
}

