/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api.advice;

import java.lang.reflect.Method;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.metrics.api.MetricsPool;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;
import org.apache.shardingsphere.agent.metrics.api.threadlocal.ElapsedTimeThreadLocal;

public final class CommandExecutorTaskAdvice
implements InstanceMethodAroundAdvice {
    public static final String COMMAND_EXECUTOR_RUN = "run";
    public static final String COMMAND_EXECUTOR_EXCEPTION = "processException";

    public void beforeMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        if (COMMAND_EXECUTOR_RUN.equals(method.getName())) {
            ElapsedTimeThreadLocal.INSTANCE.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        if (COMMAND_EXECUTOR_RUN.equals(method.getName())) {
            try {
                long elapsedTime = System.currentTimeMillis() - ElapsedTimeThreadLocal.INSTANCE.get();
                MetricsPool.get("proxy_execute_latency_millis").ifPresent(optional -> optional.observe(elapsedTime));
            }
            finally {
                ElapsedTimeThreadLocal.INSTANCE.remove();
            }
        } else if (COMMAND_EXECUTOR_EXCEPTION.equals(method.getName())) {
            MetricsPool.get("proxy_execute_error_total").ifPresent(MetricsWrapper::inc);
        }
    }

    static {
        MetricsPool.create("proxy_execute_error_total");
        MetricsPool.create("proxy_execute_latency_millis");
    }
}

