/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api.advice;

import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.metrics.api.MetricsPool;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChannelHandlerAdvice
implements InstanceMethodAroundAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChannelHandlerAdvice.class);
    public static final String CHANNEL_READ = "channelRead";
    public static final String CHANNEL_ACTIVE = "channelActive";
    public static final String CHANNEL_INACTIVE = "channelInactive";

    public void beforeMethod(AdviceTargetObject target, Method method, Object[] args, MethodInvocationResult result) {
        switch (method.getName()) {
            case "channelRead": {
                MetricsPool.get("proxy_request_total").ifPresent(MetricsWrapper::inc);
                break;
            }
            case "channelActive": {
                MetricsPool.get("proxy_connection_total").ifPresent(MetricsWrapper::inc);
                break;
            }
            case "channelInactive": {
                MetricsPool.get("proxy_connection_total").ifPresent(MetricsWrapper::dec);
                break;
            }
        }
    }

    static {
        MetricsPool.create("proxy_request_total");
        MetricsPool.create("proxy_connection_total");
    }
}

