/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.metrics.api;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapper;
import org.apache.shardingsphere.agent.metrics.api.MetricsWrapperFactory;

public final class MetricsPool {
    private static final ConcurrentHashMap<String, MetricsWrapper> METRICS_POOL = new ConcurrentHashMap();
    private static MetricsWrapperFactory wrapperFactory;

    public static void setMetricsFactory(MetricsWrapperFactory factory) {
        wrapperFactory = factory;
    }

    public static void create(String id) {
        Optional<MetricsWrapper> wrapper = wrapperFactory.create(id);
        wrapper.ifPresent(optional -> METRICS_POOL.put(id, (MetricsWrapper)optional));
    }

    public static Optional<MetricsWrapper> get(String id) {
        return Optional.ofNullable(METRICS_POOL.get(id));
    }
}

