/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bytecode.assign;

import org.apache.shardingsphere.dependencies.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.type.TypeDefinition;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.Implementation;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bytecode.StackSize;
import org.apache.shardingsphere.dependencies.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.shardingsphere.dependencies.net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class TypeCasting
extends StackManipulation.AbstractBase {
    private final TypeDescription typeDescription;

    protected TypeCasting(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    public static StackManipulation to(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            throw new IllegalArgumentException("Cannot cast to primitive type: " + typeDefinition);
        }
        return new TypeCasting(typeDefinition.asErasure());
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitTypeInsn(192, this.typeDescription.getInternalName());
        return StackSize.ZERO.toIncreasingSize();
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.typeDescription.equals(((TypeCasting)object).typeDescription);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.typeDescription.hashCode();
    }
}

