/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.spi.definition;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.agent.api.point.PluginInterceptorPoint;
import org.apache.shardingsphere.agent.spi.definition.PluginDefinitionService;

public abstract class AbstractPluginDefinitionService
implements PluginDefinitionService {
    private final Map<String, PluginInterceptorPoint.Builder> interceptorPointMap = new HashMap<String, PluginInterceptorPoint.Builder>();

    public abstract void defineInterceptors();

    public final Collection<PluginInterceptorPoint> install() {
        this.defineInterceptors();
        return this.interceptorPointMap.values().stream().map(PluginInterceptorPoint.Builder::install).collect(Collectors.toList());
    }

    protected final PluginInterceptorPoint.Builder defineInterceptor(String classNameOfTarget) {
        if (this.interceptorPointMap.containsKey(classNameOfTarget)) {
            return this.interceptorPointMap.get(classNameOfTarget);
        }
        PluginInterceptorPoint.Builder builder = PluginInterceptorPoint.intercept(classNameOfTarget);
        this.interceptorPointMap.put(classNameOfTarget, builder);
        return builder;
    }
}

