/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.spi;

import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.exception.AgentServiceProviderNotFoundException;
import org.apache.shardingsphere.agent.core.spi.AgentServiceLoader;
import org.apache.shardingsphere.agent.spi.type.AgentTypedSPI;

public final class AgentTypedSPIRegistry {
    public static <T extends AgentTypedSPI> T getRegisteredService(Class<T> typedSPIClass, String type) {
        Optional<AgentTypedSPI> serviceInstance = AgentServiceLoader.getServiceLoader(typedSPIClass).newServiceInstances().stream().filter(each -> each.getType().equalsIgnoreCase(type)).findFirst();
        if (serviceInstance.isPresent()) {
            return (T)serviceInstance.get();
        }
        throw new AgentServiceProviderNotFoundException(typedSPIClass, type);
    }

    public static <T extends AgentTypedSPI> Optional<T> getRegisteredServiceOptional(Class<T> typedSPIClass, String type) {
        return AgentServiceLoader.getServiceLoader(typedSPIClass).newServiceInstances().stream().filter(each -> each.getType().equalsIgnoreCase(type)).findFirst();
    }

    public static <T extends AgentTypedSPI> Collection<T> getAllRegisteredService(Class<T> typedSPIClass) {
        return AgentServiceLoader.getServiceLoader(typedSPIClass).newServiceInstances();
    }

    @Generated
    private AgentTypedSPIRegistry() {
    }
}

