/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.spi;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.agent.core.plugin.AgentPluginLoader;

public final class AgentServiceLoader<T> {
    private static final Map<Class<?>, AgentServiceLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Map<Class<?>, Collection<T>> serviceMap = new ConcurrentHashMap();
    private final Class<T> service;

    private AgentServiceLoader(Class<T> service) {
        this.service = service;
        this.register(service);
    }

    public static <T> AgentServiceLoader<T> getServiceLoader(Class<T> service) {
        if (null == service) {
            throw new NullPointerException("extension clazz is null");
        }
        if (!service.isInterface()) {
            throw new IllegalArgumentException(String.format("extension clazz ( %s is not interface!", service));
        }
        AgentServiceLoader<?> agentServiceLoader = LOADERS.get(service);
        if (null != agentServiceLoader) {
            return agentServiceLoader;
        }
        LOADERS.putIfAbsent(service, new AgentServiceLoader<T>(service));
        return LOADERS.get(service);
    }

    public Collection<T> newServiceInstances() {
        return this.serviceMap.get(this.service);
    }

    private void register(Class<T> service) {
        if (this.serviceMap.containsKey(service)) {
            return;
        }
        this.serviceMap.put(service, new LinkedList());
        ServiceLoader.load(service, AgentPluginLoader.getInstance()).forEach(each -> this.serviceMap.get(service).add(each));
    }
}

