/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin.interceptor;

import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.advice.OverrideArgsInvoker;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.core.plugin.PluginContext;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMethodInterceptorArgsOverride {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstanceMethodInterceptorArgsOverride.class);
    private final InstanceMethodAroundAdvice instanceMethodAroundAdvice;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@This Object target, @Origin Method method, @AllArguments Object[] args, @Morph OverrideArgsInvoker callable) {
        Object object;
        Object result;
        AdviceTargetObject instance = (AdviceTargetObject)target;
        MethodInvocationResult methodResult = new MethodInvocationResult();
        boolean adviceEnabled = this.instanceMethodAroundAdvice.disableCheck() || PluginContext.isPluginEnabled();
        try {
            if (adviceEnabled) {
                this.instanceMethodAroundAdvice.beforeMethod(instance, method, args, methodResult);
            }
        }
        catch (Throwable ex) {
            log.error("Failed to execute the pre-method of method[{}] in class[{}]", new Object[]{method.getName(), target.getClass(), ex});
        }
        try {
            result = methodResult.isRebased() ? methodResult.getResult() : callable.call(args);
            methodResult.rebase(result);
        }
        catch (Throwable ex) {
            try {
                try {
                    if (!adviceEnabled) throw ex;
                    this.instanceMethodAroundAdvice.onThrowing(instance, method, args, ex);
                    throw ex;
                }
                catch (Throwable ignored) {
                    log.error("Failed to execute the error handler of method[{}] in class[{}]", new Object[]{method.getName(), target.getClass(), ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    if (!adviceEnabled) throw throwable;
                    this.instanceMethodAroundAdvice.afterMethod(instance, method, args, methodResult);
                    throw throwable;
                }
                catch (Throwable ex2) {
                    log.error("Failed to execute the post-method of method[{}] in class[{}]", new Object[]{method.getName(), target.getClass(), ex2});
                }
                throw throwable;
            }
        }
        try {
            if (adviceEnabled) {
                this.instanceMethodAroundAdvice.afterMethod(instance, method, args, methodResult);
            }
        }
        catch (Throwable ex) {
            log.error("Failed to execute the post-method of method[{}] in class[{}]", new Object[]{method.getName(), target.getClass(), ex});
        }
        if (methodResult.isRebased()) {
            object = methodResult.getResult();
            return object;
        }
        object = result;
        return object;
    }

    @Generated
    public InstanceMethodInterceptorArgsOverride(InstanceMethodAroundAdvice instanceMethodAroundAdvice) {
        this.instanceMethodAroundAdvice = instanceMethodAroundAdvice;
    }
}

