/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin.interceptor;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.ClassStaticMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.result.MethodInvocationResult;
import org.apache.shardingsphere.agent.core.plugin.PluginContext;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.AllArguments;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.Origin;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.SuperCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassStaticMethodAroundInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassStaticMethodAroundInterceptor.class);
    private final ClassStaticMethodAroundAdvice classStaticMethodAroundAdvice;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> klass, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) {
        Object object;
        Object result;
        MethodInvocationResult methodResult = new MethodInvocationResult();
        boolean adviceEnabled = this.classStaticMethodAroundAdvice.disableCheck() || PluginContext.isPluginEnabled();
        try {
            if (adviceEnabled) {
                this.classStaticMethodAroundAdvice.beforeMethod(klass, method, args, methodResult);
            }
        }
        catch (Throwable ex) {
            log.error("Failed to execute the pre-method of method[{}] in class[{}]", new Object[]{method.getName(), klass, ex});
        }
        try {
            result = methodResult.isRebased() ? methodResult.getResult() : callable.call();
            methodResult.rebase(result);
        }
        catch (Throwable ex) {
            try {
                try {
                    if (!adviceEnabled) throw ex;
                    this.classStaticMethodAroundAdvice.onThrowing(klass, method, args, ex);
                    throw ex;
                }
                catch (Throwable ignored) {
                    log.error("Failed to execute the error handler of method[{}] in class[{}]", new Object[]{method.getName(), klass, ex});
                }
                throw ex;
            }
            catch (Throwable throwable) {
                try {
                    if (!adviceEnabled) throw throwable;
                    this.classStaticMethodAroundAdvice.afterMethod(klass, method, args, methodResult);
                    throw throwable;
                }
                catch (Throwable ex2) {
                    log.error("Failed to execute the post-method of method[{}] in class[{}]", new Object[]{method.getName(), klass, ex2});
                }
                throw throwable;
            }
        }
        try {
            if (adviceEnabled) {
                this.classStaticMethodAroundAdvice.afterMethod(klass, method, args, methodResult);
            }
        }
        catch (Throwable ex) {
            log.error("Failed to execute the post-method of method[{}] in class[{}]", new Object[]{method.getName(), klass, ex});
        }
        if (methodResult.isRebased()) {
            object = methodResult.getResult();
            return object;
        }
        object = result;
        return object;
    }

    @Generated
    public ClassStaticMethodAroundInterceptor(ClassStaticMethodAroundAdvice classStaticMethodAroundAdvice) {
        this.classStaticMethodAroundAdvice = classStaticMethodAroundAdvice;
    }
}

