/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.agent.config.AgentConfiguration;
import org.apache.shardingsphere.agent.config.PluginConfiguration;
import org.apache.shardingsphere.agent.core.config.registry.AgentConfigurationRegistry;
import org.apache.shardingsphere.agent.core.spi.AgentTypedSPIRegistry;
import org.apache.shardingsphere.agent.spi.boot.PluginBootService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginBootServiceManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginBootServiceManager.class);

    public static void startAllServices(Map<String, PluginConfiguration> pluginConfigurationMap) {
        Set<String> ignoredPluginNames = AgentConfigurationRegistry.INSTANCE.get(AgentConfiguration.class).getIgnoredPluginNames();
        for (Map.Entry<String, PluginConfiguration> entry : pluginConfigurationMap.entrySet()) {
            if (!ignoredPluginNames.isEmpty() && ignoredPluginNames.contains(entry.getKey())) continue;
            AgentTypedSPIRegistry.getRegisteredServiceOptional(PluginBootService.class, entry.getKey()).ifPresent(optional -> {
                try {
                    log.info("Start plugin: {}", (Object)optional.getType());
                    optional.start((PluginConfiguration)entry.getValue());
                }
                catch (Throwable ex) {
                    log.error("Failed to start service", ex);
                }
            });
        }
    }

    public static void closeAllServices() {
        AgentTypedSPIRegistry.getAllRegisteredService(PluginBootService.class).forEach(each -> {
            try {
                each.close();
            }
            catch (Throwable ex) {
                log.error("Failed to close service", ex);
            }
        });
    }

    @Generated
    private PluginBootServiceManager() {
    }
}

