/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.plugin;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.point.PluginInterceptorPoint;
import org.apache.shardingsphere.agent.config.AgentConfiguration;
import org.apache.shardingsphere.agent.core.config.path.AgentPathBuilder;
import org.apache.shardingsphere.agent.core.config.registry.AgentConfigurationRegistry;
import org.apache.shardingsphere.agent.core.plugin.PluginLoader;
import org.apache.shardingsphere.agent.core.spi.PluginServiceLoader;
import org.apache.shardingsphere.agent.spi.definition.AbstractPluginDefinitionService;
import org.apache.shardingsphere.agent.spi.definition.PluginDefinitionService;
import org.apache.shardingsphere.dependencies.com.google.common.collect.ImmutableMap;
import org.apache.shardingsphere.dependencies.com.google.common.io.ByteStreams;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shardingsphere.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AgentPluginLoader
extends ClassLoader
implements Closeable,
PluginLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentPluginLoader.class);
    private static volatile AgentPluginLoader pluginLoader;
    private final ConcurrentHashMap<String, Object> objectPool = new ConcurrentHashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private final List<PluginJar> jars = new ArrayList<PluginJar>();
    private Map<String, PluginInterceptorPoint> interceptorPointMap;

    private AgentPluginLoader() {
        super(AgentPluginLoader.class.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentPluginLoader getInstance() {
        if (null != pluginLoader) return pluginLoader;
        Class<AgentPluginLoader> clazz = AgentPluginLoader.class;
        synchronized (AgentPluginLoader.class) {
            if (null != pluginLoader) return pluginLoader;
            pluginLoader = new AgentPluginLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pluginLoader;
        }
    }

    public void loadAllPlugins() throws IOException {
        File[] jarFiles = AgentPathBuilder.getPluginPath().listFiles(each -> each.getName().endsWith(".jar"));
        if (null == jarFiles) {
            return;
        }
        HashMap<String, PluginInterceptorPoint> pointMap = new HashMap<String, PluginInterceptorPoint>();
        Set<String> ignoredPluginNames = AgentConfigurationRegistry.INSTANCE.get(AgentConfiguration.class).getIgnoredPluginNames();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (File each2 : jarFiles) {
                outputStream.reset();
                JarFile jar = new JarFile(each2, true);
                this.jars.add(new PluginJar(jar, each2));
                log.info("Loaded jar {}", (Object)each2.getName());
            }
        }
        this.loadPluginDefinitionServices(ignoredPluginNames, pointMap);
        this.interceptorPointMap = ImmutableMap.builder().putAll(pointMap).build();
    }

    public ElementMatcher<? super TypeDescription> typeMatcher() {
        return new ElementMatcher.Junction<TypeDescription>(){

            @Override
            public boolean matches(TypeDescription target) {
                return AgentPluginLoader.this.interceptorPointMap.containsKey(target.getTypeName());
            }

            @Override
            public <U extends TypeDescription> ElementMatcher.Junction<U> and(ElementMatcher<? super U> other) {
                return null;
            }

            @Override
            public <U extends TypeDescription> ElementMatcher.Junction<U> or(ElementMatcher<? super U> other) {
                return null;
            }
        };
    }

    @Override
    public boolean containsType(TypeDescription typeDescription) {
        return this.interceptorPointMap.containsKey(typeDescription.getTypeName());
    }

    @Override
    public PluginInterceptorPoint loadPluginInterceptorPoint(TypeDescription typeDescription) {
        return this.interceptorPointMap.getOrDefault(typeDescription.getTypeName(), PluginInterceptorPoint.createDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getOrCreateInstance(String adviceClassName) {
        if (this.objectPool.containsKey(adviceClassName)) {
            return (T)this.objectPool.get(adviceClassName);
        }
        this.lock.lock();
        try {
            Object inst = this.objectPool.get(adviceClassName);
            if (Objects.isNull(inst)) {
                inst = Class.forName(adviceClassName, true, this).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.objectPool.put(adviceClassName, inst);
            }
            Object object = inst;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = this.classNameToPath(name);
        for (PluginJar each : this.jars) {
            ZipEntry entry = each.jarFile.getEntry(path);
            if (!Objects.nonNull(entry)) continue;
            try {
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String packageName = name.substring(0, index);
                    this.definePackageInternal(packageName, each.jarFile.getManifest());
                }
                byte[] data = ByteStreams.toByteArray(each.jarFile.getInputStream(entry));
                return this.defineClass(name, data, 0, data.length);
            }
            catch (IOException ex) {
                log.error("Failed to load class {}", (Object)name, (Object)ex);
            }
        }
        throw new ClassNotFoundException(String.format("Class name is %s not found", name));
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        LinkedList<URL> resources = new LinkedList<URL>();
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                resources.add(new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name)));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected URL findResource(String name) {
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                return new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name));
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    @Override
    public void close() {
        for (PluginJar each : this.jars) {
            try {
                each.jarFile.close();
            }
            catch (IOException ex) {
                log.error("Exception occur when closing jar", (Throwable)ex);
            }
        }
    }

    private void loadPluginDefinitionServices(Set<String> ignoredPluginNames, Map<String, PluginInterceptorPoint> pointMap) {
        PluginServiceLoader.newServiceInstances(PluginDefinitionService.class).stream().filter(each -> ignoredPluginNames.isEmpty() || !ignoredPluginNames.contains(each.getType())).forEach(each -> this.buildPluginInterceptorPointMap((PluginDefinitionService)each, pointMap));
    }

    private String classNameToPath(String className) {
        return String.join((CharSequence)"", className.replace(".", "/"), ".class");
    }

    private void definePackageInternal(String packageName, Manifest manifest) {
        if (null != this.getPackage(packageName)) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    private void buildPluginInterceptorPointMap(PluginDefinitionService pluginDefinitionService, Map<String, PluginInterceptorPoint> pointMap) {
        log.info("Load plugin: {}", (Object)pluginDefinitionService.getType());
        AbstractPluginDefinitionService definitionService = (AbstractPluginDefinitionService)pluginDefinitionService;
        definitionService.install().forEach(each -> {
            String target = each.getClassNameOfTarget();
            if (pointMap.containsKey(target)) {
                PluginInterceptorPoint pluginInterceptorPoint = (PluginInterceptorPoint)pointMap.get(target);
                pluginInterceptorPoint.getConstructorPoints().addAll(each.getConstructorPoints());
                pluginInterceptorPoint.getInstanceMethodPoints().addAll(each.getInstanceMethodPoints());
                pluginInterceptorPoint.getClassStaticMethodPoints().addAll(each.getClassStaticMethodPoints());
            } else {
                pointMap.put(target, (PluginInterceptorPoint)each);
            }
        });
    }

    static {
        AgentPluginLoader.registerAsParallelCapable();
    }

    private static class PluginJar {
        private final JarFile jarFile;
        private final File sourcePath;

        @Generated
        public PluginJar(JarFile jarFile, File sourcePath) {
            this.jarFile = jarFile;
            this.sourcePath = sourcePath;
        }
    }
}

