/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.config.path;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.exception.ShardingSphereAgentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AgentPathBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgentPathBuilder.class);
    private static File agentPath = AgentPathBuilder.buildAgentPath();
    private static File pluginPath = AgentPathBuilder.buildAgentPluginPath();

    private static File buildAgentPath() {
        String classResourcePath = String.join((CharSequence)"", AgentPathBuilder.class.getName().replaceAll("\\.", "/"), ".class");
        URL resource = ClassLoader.getSystemClassLoader().getResource(classResourcePath);
        if (null != resource) {
            String url = resource.toString();
            log.debug("The beacon class location is {}", (Object)url);
            int existFileInJarIndex = url.indexOf(33);
            boolean isInJar = existFileInJarIndex > -1;
            return isInJar ? AgentPathBuilder.getFileInJar(url, existFileInJarIndex) : AgentPathBuilder.getFileInResource(url, classResourcePath);
        }
        throw new ShardingSphereAgentException("Can not locate agent jar file.", new Object[0]);
    }

    private static File getFileInResource(String url, String classResourcePath) {
        int prefixLength = "file:".length();
        String classLocation = url.substring(prefixLength, url.length() - classResourcePath.length());
        return new File(classLocation);
    }

    private static File getFileInJar(String url, int fileInJarIndex) {
        String realUrl = url.substring(url.indexOf("file:"), fileInJarIndex);
        try {
            File agentJarFile = new File(new URL(realUrl).toURI());
            return agentJarFile.exists() ? agentJarFile.getParentFile() : null;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            log.error(String.format("Can not locate agent jar file by url %s", url), (Throwable)ex);
            return null;
        }
    }

    private static File buildAgentPluginPath() {
        return new File(String.join((CharSequence)"", agentPath.getPath(), "/plugins"));
    }

    @Generated
    private AgentPathBuilder() {
    }

    @Generated
    public static File getAgentPath() {
        return agentPath;
    }

    @Generated
    public static File getPluginPath() {
        return pluginPath;
    }
}

