/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.config.loader;

import java.io.File;
import java.io.IOException;
import lombok.Generated;
import org.apache.shardingsphere.agent.config.AgentConfiguration;
import org.apache.shardingsphere.agent.core.config.path.AgentPathBuilder;
import org.apache.shardingsphere.agent.core.config.yaml.YamlAgentConfiguration;
import org.apache.shardingsphere.agent.core.config.yaml.engine.YamlEngine;
import org.apache.shardingsphere.agent.core.config.yaml.swapper.YamlAgentConfigurationSwapper;
import org.apache.shardingsphere.dependencies.com.google.common.base.Preconditions;

public final class AgentConfigurationLoader {
    private static final String DEFAULT_CONFIG_PATH = "/conf/agent.yaml";

    public static AgentConfiguration load() throws IOException {
        File configFile = new File(AgentPathBuilder.getAgentPath(), DEFAULT_CONFIG_PATH);
        return YamlAgentConfigurationSwapper.swap(AgentConfigurationLoader.load(configFile));
    }

    private static YamlAgentConfiguration load(File yamlFile) throws IOException {
        YamlAgentConfiguration result = YamlEngine.unmarshal(yamlFile, YamlAgentConfiguration.class);
        Preconditions.checkNotNull(result, "Agent configuration file `%s` is invalid.", (Object)yamlFile.getName());
        return result;
    }

    @Generated
    private AgentConfigurationLoader() {
    }
}

