/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.bytebuddy.transformer;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.advice.AdviceTargetObject;
import org.apache.shardingsphere.agent.api.advice.ClassStaticMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.advice.ConstructorAdvice;
import org.apache.shardingsphere.agent.api.advice.InstanceMethodAroundAdvice;
import org.apache.shardingsphere.agent.api.advice.OverrideArgsInvoker;
import org.apache.shardingsphere.agent.api.point.ClassStaticMethodPoint;
import org.apache.shardingsphere.agent.api.point.ConstructorPoint;
import org.apache.shardingsphere.agent.api.point.InstanceMethodPoint;
import org.apache.shardingsphere.agent.api.point.PluginInterceptorPoint;
import org.apache.shardingsphere.agent.core.bytebuddy.transformer.ShardingSphereTransformationPoint;
import org.apache.shardingsphere.agent.core.plugin.PluginLoader;
import org.apache.shardingsphere.agent.core.plugin.interceptor.ClassStaticMethodAroundInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.ClassStaticMethodInterceptorArgsOverride;
import org.apache.shardingsphere.agent.core.plugin.interceptor.ConstructorInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.InstanceMethodAroundInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.InstanceMethodInterceptorArgsOverride;
import org.apache.shardingsphere.agent.core.plugin.interceptor.compose.ComposeClassStaticMethodAroundInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.compose.ComposeClassStaticMethodInterceptorArgsOverride;
import org.apache.shardingsphere.agent.core.plugin.interceptor.compose.ComposeConstructorInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.compose.ComposeInstanceMethodAroundInterceptor;
import org.apache.shardingsphere.agent.core.plugin.interceptor.compose.ComposeInstanceMethodInterceptorArgsOverride;
import org.apache.shardingsphere.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shardingsphere.dependencies.net.bytebuddy.dynamic.DynamicType;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.FieldAccessor;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.MethodDelegation;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.SuperMethodCall;
import org.apache.shardingsphere.dependencies.net.bytebuddy.implementation.bind.annotation.Morph;
import org.apache.shardingsphere.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.shardingsphere.dependencies.net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingSphereTransformer
implements AgentBuilder.Transformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardingSphereTransformer.class);
    private static final String EXTRA_DATA = "_$EXTRA_DATA$_";
    private final PluginLoader pluginLoader;

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        if (!this.pluginLoader.containsType(typeDescription)) {
            return builder;
        }
        DynamicType.Builder<Object> result = builder.defineField(EXTRA_DATA, (Type)((Object)Object.class), 66).implement(new Type[]{AdviceTargetObject.class}).intercept(FieldAccessor.ofField(EXTRA_DATA));
        PluginInterceptorPoint pluginInterceptorPoint = this.pluginLoader.loadPluginInterceptorPoint(typeDescription);
        result = this.interceptorConstructorPoint(typeDescription, pluginInterceptorPoint.getConstructorPoints(), result);
        result = this.interceptorClassStaticMethodPoint(typeDescription, pluginInterceptorPoint.getClassStaticMethodPoints(), result);
        result = this.interceptorInstanceMethodPoint(typeDescription, pluginInterceptorPoint.getInstanceMethodPoints(), result);
        return result;
    }

    private DynamicType.Builder<?> interceptorConstructorPoint(TypeDescription description, Collection<ConstructorPoint> constructorPoints, DynamicType.Builder<?> builder) {
        Collection constructorAdviceComposePoints = description.getDeclaredMethods().stream().filter(MethodDescription::isConstructor).map(each -> this.getMatchedTransformationPoint(constructorPoints, (MethodDescription.InDefinedShape)each)).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicType.Builder<?> result = builder;
        for (ShardingSphereTransformationPoint each2 : constructorAdviceComposePoints) {
            try {
                result = result.constructor(ElementMatchers.is(each2.getDescription())).intercept(SuperMethodCall.INSTANCE.andThen(MethodDelegation.withDefaultConfiguration().to(each2.getInterceptor())));
            }
            catch (Throwable ex) {
                log.error("Failed to load advice class: {}", (Object)description.getTypeName(), (Object)ex);
            }
        }
        return result;
    }

    private ShardingSphereTransformationPoint<? extends ConstructorInterceptor> getMatchedTransformationPoint(Collection<ConstructorPoint> constructorPoints, MethodDescription.InDefinedShape methodDescription) {
        List matchedConstructorPoints = constructorPoints.stream().filter(each -> each.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (matchedConstructorPoints.isEmpty()) {
            return null;
        }
        if (1 == matchedConstructorPoints.size()) {
            return new ShardingSphereTransformationPoint<ConstructorInterceptor>(methodDescription, new ConstructorInterceptor((ConstructorAdvice)this.pluginLoader.getOrCreateInstance(((ConstructorPoint)matchedConstructorPoints.get(0)).getAdvice())));
        }
        Collection constructorAdvices = matchedConstructorPoints.stream().map(ConstructorPoint::getAdvice).map(each -> (ConstructorAdvice)this.pluginLoader.getOrCreateInstance((String)each)).collect(Collectors.toList());
        return new ShardingSphereTransformationPoint<ComposeConstructorInterceptor>(methodDescription, new ComposeConstructorInterceptor(constructorAdvices));
    }

    private DynamicType.Builder<?> interceptorClassStaticMethodPoint(TypeDescription description, Collection<ClassStaticMethodPoint> staticMethodAroundPoints, DynamicType.Builder<?> builder) {
        Collection classStaticMethodAdvicePoints = description.getDeclaredMethods().stream().filter(each -> each.isStatic() && !each.isAbstract() && !each.isSynthetic()).map(each -> this.getMatchedStaticMethodPoint(staticMethodAroundPoints, (MethodDescription.InDefinedShape)each)).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicType.Builder<?> result = builder;
        for (ShardingSphereTransformationPoint each2 : classStaticMethodAdvicePoints) {
            try {
                if (each2.getInterceptor() instanceof ClassStaticMethodInterceptorArgsOverride || each2.getInterceptor() instanceof ComposeClassStaticMethodInterceptorArgsOverride) {
                    result = result.method(ElementMatchers.is(each2.getDescription())).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideArgsInvoker.class)).to(each2.getInterceptor()));
                    continue;
                }
                result = result.method(ElementMatchers.is(each2.getDescription())).intercept(MethodDelegation.withDefaultConfiguration().to(each2.getInterceptor()));
            }
            catch (Throwable ex) {
                log.error("Failed to load advice class: {}", (Object)description.getTypeName(), (Object)ex);
            }
        }
        return result;
    }

    private ShardingSphereTransformationPoint<?> getMatchedStaticMethodPoint(Collection<ClassStaticMethodPoint> staticMethodAroundPoints, MethodDescription.InDefinedShape methodDescription) {
        List<ClassStaticMethodPoint> staticMethodPoints = staticMethodAroundPoints.stream().filter(each -> each.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (staticMethodPoints.isEmpty()) {
            return null;
        }
        if (1 == staticMethodPoints.size()) {
            return this.getSingleStaticMethodPoint(methodDescription, staticMethodPoints.get(0));
        }
        return this.getComposeStaticMethodPoint(methodDescription, staticMethodPoints);
    }

    private ShardingSphereTransformationPoint<?> getSingleStaticMethodPoint(MethodDescription.InDefinedShape methodDescription, ClassStaticMethodPoint staticMethodPoint) {
        ClassStaticMethodAroundAdvice staticMethodAroundAdvice = (ClassStaticMethodAroundAdvice)this.pluginLoader.getOrCreateInstance(staticMethodPoint.getAdvice());
        return staticMethodPoint.isOverrideArgs() ? new ShardingSphereTransformationPoint<ClassStaticMethodInterceptorArgsOverride>(methodDescription, new ClassStaticMethodInterceptorArgsOverride(staticMethodAroundAdvice)) : new ShardingSphereTransformationPoint<ClassStaticMethodAroundInterceptor>(methodDescription, new ClassStaticMethodAroundInterceptor(staticMethodAroundAdvice));
    }

    private ShardingSphereTransformationPoint<?> getComposeStaticMethodPoint(MethodDescription.InDefinedShape methodDescription, Collection<ClassStaticMethodPoint> staticMethodPoints) {
        LinkedList<ClassStaticMethodAroundAdvice> classStaticMethodAroundAdvices = new LinkedList<ClassStaticMethodAroundAdvice>();
        boolean isArgsOverride = false;
        for (ClassStaticMethodPoint each : staticMethodPoints) {
            if (each.isOverrideArgs()) {
                isArgsOverride = true;
            }
            if (null == each.getAdvice()) continue;
            classStaticMethodAroundAdvices.add((ClassStaticMethodAroundAdvice)this.pluginLoader.getOrCreateInstance(each.getAdvice()));
        }
        return isArgsOverride ? new ShardingSphereTransformationPoint<ComposeClassStaticMethodInterceptorArgsOverride>(methodDescription, new ComposeClassStaticMethodInterceptorArgsOverride(classStaticMethodAroundAdvices)) : new ShardingSphereTransformationPoint<ComposeClassStaticMethodAroundInterceptor>(methodDescription, new ComposeClassStaticMethodAroundInterceptor(classStaticMethodAroundAdvices));
    }

    private DynamicType.Builder<?> interceptorInstanceMethodPoint(TypeDescription description, Collection<InstanceMethodPoint> instanceMethodAroundPoints, DynamicType.Builder<?> builder) {
        Collection instanceMethodAdviceComposePoints = description.getDeclaredMethods().stream().filter(each -> !each.isAbstract() && !each.isSynthetic()).map(each -> this.getMatchedInstanceMethodPoint(instanceMethodAroundPoints, (MethodDescription.InDefinedShape)each)).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicType.Builder<?> result = builder;
        for (ShardingSphereTransformationPoint each2 : instanceMethodAdviceComposePoints) {
            try {
                if (each2.getInterceptor() instanceof InstanceMethodInterceptorArgsOverride || each2.getInterceptor() instanceof ComposeInstanceMethodInterceptorArgsOverride) {
                    result = result.method(ElementMatchers.is(each2.getDescription())).intercept(MethodDelegation.withDefaultConfiguration().withBinders(Morph.Binder.install(OverrideArgsInvoker.class)).to(each2.getInterceptor()));
                    continue;
                }
                result = result.method(ElementMatchers.is(each2.getDescription())).intercept(MethodDelegation.withDefaultConfiguration().to(each2.getInterceptor()));
            }
            catch (Throwable ex) {
                log.error("Failed to load advice class: {}", (Object)description.getTypeName(), (Object)ex);
            }
        }
        return result;
    }

    private ShardingSphereTransformationPoint<?> getMatchedInstanceMethodPoint(Collection<InstanceMethodPoint> instanceMethodAroundPoints, MethodDescription.InDefinedShape methodDescription) {
        List<InstanceMethodPoint> instanceMethodPoints = instanceMethodAroundPoints.stream().filter(each -> each.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (instanceMethodPoints.isEmpty()) {
            return null;
        }
        if (1 == instanceMethodPoints.size()) {
            return this.getSingleInstanceMethodPoint(methodDescription, instanceMethodPoints.get(0));
        }
        return this.getComposeInstanceMethodPoint(methodDescription, instanceMethodPoints);
    }

    private ShardingSphereTransformationPoint<?> getSingleInstanceMethodPoint(MethodDescription.InDefinedShape methodDescription, InstanceMethodPoint instanceMethodPoint) {
        InstanceMethodAroundAdvice instanceMethodAroundAdvice = (InstanceMethodAroundAdvice)this.pluginLoader.getOrCreateInstance(instanceMethodPoint.getAdvice());
        return instanceMethodPoint.isOverrideArgs() ? new ShardingSphereTransformationPoint<InstanceMethodInterceptorArgsOverride>(methodDescription, new InstanceMethodInterceptorArgsOverride(instanceMethodAroundAdvice)) : new ShardingSphereTransformationPoint<InstanceMethodAroundInterceptor>(methodDescription, new InstanceMethodAroundInterceptor(instanceMethodAroundAdvice));
    }

    private ShardingSphereTransformationPoint<?> getComposeInstanceMethodPoint(MethodDescription.InDefinedShape methodDescription, Collection<InstanceMethodPoint> instanceMethodPoints) {
        LinkedList<InstanceMethodAroundAdvice> instanceMethodAroundAdvices = new LinkedList<InstanceMethodAroundAdvice>();
        boolean isArgsOverride = false;
        for (InstanceMethodPoint each : instanceMethodPoints) {
            if (each.isOverrideArgs()) {
                isArgsOverride = true;
            }
            if (null == each.getAdvice()) continue;
            instanceMethodAroundAdvices.add((InstanceMethodAroundAdvice)this.pluginLoader.getOrCreateInstance(each.getAdvice()));
        }
        return isArgsOverride ? new ShardingSphereTransformationPoint<ComposeInstanceMethodInterceptorArgsOverride>(methodDescription, new ComposeInstanceMethodInterceptorArgsOverride(instanceMethodAroundAdvices)) : new ShardingSphereTransformationPoint<ComposeInstanceMethodAroundInterceptor>(methodDescription, new ComposeInstanceMethodAroundInterceptor(instanceMethodAroundAdvices));
    }

    @Generated
    public ShardingSphereTransformer(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }
}

