/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.bootstrap;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.agent.config.AgentConfiguration;
import org.apache.shardingsphere.agent.config.PluginConfiguration;
import org.apache.shardingsphere.agent.core.bytebuddy.listener.LoggingListener;
import org.apache.shardingsphere.agent.core.bytebuddy.transformer.ShardingSphereTransformer;
import org.apache.shardingsphere.agent.core.config.loader.AgentConfigurationLoader;
import org.apache.shardingsphere.agent.core.config.registry.AgentConfigurationRegistry;
import org.apache.shardingsphere.agent.core.plugin.AgentPluginLoader;
import org.apache.shardingsphere.agent.core.plugin.PluginBootServiceManager;
import org.apache.shardingsphere.dependencies.net.bytebuddy.ByteBuddy;
import org.apache.shardingsphere.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.shardingsphere.dependencies.net.bytebuddy.dynamic.scaffold.TypeValidation;
import org.apache.shardingsphere.dependencies.net.bytebuddy.matcher.ElementMatchers;

public final class ShardingSphereAgent {
    public static void premain(String arguments, Instrumentation instrumentation) throws IOException {
        AgentConfiguration agentConfig = AgentConfigurationLoader.load();
        AgentConfigurationRegistry.INSTANCE.put(agentConfig);
        AgentPluginLoader loader = ShardingSphereAgent.createPluginLoader();
        ShardingSphereAgent.setUpAgentBuilder(instrumentation, loader);
        ShardingSphereAgent.setupPluginBootService(agentConfig.getPlugins());
    }

    private static AgentPluginLoader createPluginLoader() throws IOException {
        AgentPluginLoader result = AgentPluginLoader.getInstance();
        result.loadAllPlugins();
        return result;
    }

    private static void setupPluginBootService(Map<String, PluginConfiguration> pluginConfigs) {
        PluginBootServiceManager.startAllServices(pluginConfigs);
        Runtime.getRuntime().addShutdownHook(new Thread(PluginBootServiceManager::closeAllServices));
    }

    private static void setUpAgentBuilder(Instrumentation instrumentation, AgentPluginLoader loader) {
        AgentBuilder agentBuilder = (AgentBuilder)new AgentBuilder.Default().with(new ByteBuddy().with(TypeValidation.ENABLED)).ignore(ElementMatchers.isSynthetic()).or(ElementMatchers.nameStartsWith("org.apache.shardingsphere.agent."));
        agentBuilder.type(loader.typeMatcher()).transform(new ShardingSphereTransformer(loader)).with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with(new LoggingListener()).installOn(instrumentation);
    }

    @Generated
    private ShardingSphereAgent() {
    }
}

