/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.api.point;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.point.ClassStaticMethodPoint;
import org.apache.shardingsphere.agent.api.point.ConstructorPoint;
import org.apache.shardingsphere.agent.api.point.InstanceMethodPoint;
import org.apache.shardingsphere.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.shardingsphere.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.shardingsphere.dependencies.net.bytebuddy.matcher.ElementMatchers;

public final class PluginInterceptorPoint {
    private final String classNameOfTarget;
    private final List<ConstructorPoint> constructorPoints;
    private final List<InstanceMethodPoint> instanceMethodPoints;
    private final List<ClassStaticMethodPoint> classStaticMethodPoints;

    public static PluginInterceptorPoint createDefault() {
        return new PluginInterceptorPoint("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static Builder intercept(String classNameOfTarget) {
        return new Builder(classNameOfTarget);
    }

    @Generated
    public String getClassNameOfTarget() {
        return this.classNameOfTarget;
    }

    @Generated
    public List<ConstructorPoint> getConstructorPoints() {
        return this.constructorPoints;
    }

    @Generated
    public List<InstanceMethodPoint> getInstanceMethodPoints() {
        return this.instanceMethodPoints;
    }

    @Generated
    public List<ClassStaticMethodPoint> getClassStaticMethodPoints() {
        return this.classStaticMethodPoints;
    }

    @Generated
    public PluginInterceptorPoint(String classNameOfTarget, List<ConstructorPoint> constructorPoints, List<InstanceMethodPoint> instanceMethodPoints, List<ClassStaticMethodPoint> classStaticMethodPoints) {
        this.classNameOfTarget = classNameOfTarget;
        this.constructorPoints = constructorPoints;
        this.instanceMethodPoints = instanceMethodPoints;
        this.classStaticMethodPoints = classStaticMethodPoints;
    }

    public static final class Builder {
        private final List<ConstructorPoint> constructorPoints = new ArrayList<ConstructorPoint>();
        private final List<InstanceMethodPoint> instanceMethodPoints = new ArrayList<InstanceMethodPoint>();
        private final List<ClassStaticMethodPoint> classStaticMethodPoints = new ArrayList<ClassStaticMethodPoint>();
        private final String classNameOfTarget;

        public ConstructorPointBuilder onConstructor(ElementMatcher<? super MethodDescription> matcher) {
            return new ConstructorPointBuilder(this, matcher);
        }

        public InstanceMethodPointBuilder aroundInstanceMethod(ElementMatcher<? super MethodDescription> matcher) {
            return new InstanceMethodPointBuilder(this, matcher);
        }

        public StaticMethodPointBuilder aroundClassStaticMethod(ElementMatcher<? super MethodDescription> matcher) {
            return new StaticMethodPointBuilder(this, matcher);
        }

        public PluginInterceptorPoint install() {
            return new PluginInterceptorPoint(this.classNameOfTarget, this.constructorPoints, this.instanceMethodPoints, this.classStaticMethodPoints);
        }

        @Generated
        public Builder(String classNameOfTarget) {
            this.classNameOfTarget = classNameOfTarget;
        }

        public static final class ConstructorPointBuilder {
            private final Builder builder;
            private final ElementMatcher<? super MethodDescription> matcher;
            private String classNameOfAdvice;

            private ConstructorPointBuilder(Builder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = ElementMatchers.isConstructor().and(matcher);
            }

            public ConstructorPointBuilder implement(String classNameOfAdvice) {
                this.classNameOfAdvice = classNameOfAdvice;
                return this;
            }

            public Builder build() {
                this.builder.constructorPoints.add(new ConstructorPoint(this.matcher, this.classNameOfAdvice));
                return this.builder;
            }
        }

        public static final class InstanceMethodPointBuilder {
            private final Builder builder;
            private String classNameOfAdvice;
            private boolean overrideArgs;
            private final ElementMatcher<? super MethodDescription> matcher;

            private InstanceMethodPointBuilder(Builder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = matcher;
            }

            public InstanceMethodPointBuilder implement(String classNameOfAdvice) {
                this.classNameOfAdvice = classNameOfAdvice;
                return this;
            }

            public InstanceMethodPointBuilder overrideArgs(boolean overrideArgs) {
                this.overrideArgs = overrideArgs;
                return this;
            }

            public Builder build() {
                this.builder.instanceMethodPoints.add(new InstanceMethodPoint(this.matcher, this.classNameOfAdvice, this.overrideArgs));
                return this.builder;
            }
        }

        public static final class StaticMethodPointBuilder {
            private final Builder builder;
            private String classNameOfAdvice;
            private boolean overrideArgs;
            private final ElementMatcher<? super MethodDescription> matcher;

            private StaticMethodPointBuilder(Builder builder, ElementMatcher<? super MethodDescription> matcher) {
                this.builder = builder;
                this.matcher = ElementMatchers.isStatic().and(matcher);
            }

            public StaticMethodPointBuilder implement(String classNameOfAdvice) {
                this.classNameOfAdvice = classNameOfAdvice;
                return this;
            }

            public StaticMethodPointBuilder overrideArgs(boolean overrideArgs) {
                this.overrideArgs = overrideArgs;
                return this;
            }

            public Builder build() {
                this.builder.classStaticMethodPoints.add(new ClassStaticMethodPoint(this.matcher, this.classNameOfAdvice, this.overrideArgs));
                return this.builder;
            }
        }
    }
}

